/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry.util;

import hudson.model.AbstractProject;
import hudson.model.ModelObject;
import hudson.plugins.dry.util.AbstractHealthDescriptor;
import hudson.plugins.dry.util.BuildResultGraph;
import hudson.plugins.dry.util.DifferenceGraph;
import hudson.plugins.dry.util.GraphConfiguration;
import hudson.plugins.dry.util.GraphConfigurationDetail;
import hudson.plugins.dry.util.GraphType;
import hudson.plugins.dry.util.HealthGraph;
import hudson.plugins.dry.util.NewVersusFixedGraph;
import hudson.plugins.dry.util.NullHealthDescriptor;
import hudson.plugins.dry.util.PriorityGraph;
import hudson.plugins.dry.util.ResultAction;
import hudson.util.ChartUtil;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class GraphConfigurationDetail
extends GraphConfiguration
implements ModelObject {
    private final AbstractProject<?, ?> project;
    private static final Logger LOGGER = Logger.getLogger(GraphConfigurationDetail.class.getName());
    private final String pluginName;
    private ResultAction<?> lastAction;
    private AbstractHealthDescriptor healthDescriptor;

    public GraphConfigurationDetail(AbstractProject<?, ?> project, String pluginName, String value) {
        super(value, GraphConfigurationDetail.createDefaultsFile(project, (String)pluginName));
        this.project = project;
        this.pluginName = pluginName;
        this.healthDescriptor = new NullHealthDescriptor();
    }

    public GraphConfigurationDetail(AbstractProject<?, ?> project, String pluginName, String value, ResultAction<?> lastAction) {
        this(project, pluginName, value);
        this.lastAction = lastAction;
        this.healthDescriptor = lastAction.getHealthDescriptor();
    }

    protected static File createDefaultsFile(AbstractProject<?, ?> project, String pluginName) {
        return new File(project.getRootDir(), pluginName + ".txt");
    }

    public AbstractProject<?, ?> getOwner() {
        return this.project;
    }

    public String getRootUrl() {
        return this.project.getAbsoluteUrl() + this.pluginName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public abstract String getDescription();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(StaplerRequest request, StaplerResponse response) {
        try {
            GraphType graphType;
            JSONObject formData = request.getSubmittedForm();
            int width = formData.getInt("width");
            int height = formData.getInt("height");
            String buildCountString = formData.getString("buildCountString");
            int buildCount = 0;
            if (StringUtils.isNotBlank((String)buildCountString)) {
                buildCount = formData.getInt("buildCountString");
            }
            String dayCountString = formData.getString("dayCountString");
            int dayCount = 0;
            if (StringUtils.isNotBlank((String)dayCountString)) {
                dayCount = formData.getInt("dayCountString");
            }
            if (GraphConfigurationDetail.isValid((int)width, (int)height, (int)buildCount, (int)dayCount, (GraphType)(graphType = GraphType.valueOf((String)StringUtils.upperCase((String)formData.getString("graphType")))))) {
                String value = this.serializeToString(width, height, buildCount, dayCount, graphType);
                this.persistValue(value, request, response);
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Can't save the form data: " + request, exception);
        }
        catch (JSONException exception) {
            LOGGER.log(Level.SEVERE, "Can't parse the form data: " + request, exception);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.log(Level.SEVERE, "Can't parse the form data: " + request, exception);
        }
        catch (ServletException exception) {
            LOGGER.log(Level.SEVERE, "Can't process the form data: " + request, exception);
        }
        finally {
            try {
                response.sendRedirect("../../");
            }
            catch (IOException exception) {
                LOGGER.log(Level.SEVERE, "Can't redirect", exception);
            }
        }
    }

    public static FormValidation checkHeight(String height) {
        try {
            if (GraphConfigurationDetail.isValidHeight((int)Integer.valueOf(height))) {
                return FormValidation.ok();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return FormValidation.error((String)"Height hallo gaats no.");
    }

    public boolean hasMeaningfulGraph() {
        return this.lastAction != null;
    }

    protected abstract void persistValue(String var1, StaplerRequest var2, StaplerResponse var3) throws IOException;

    public String getBuildCountString() {
        if (this.isBuildCountDefined()) {
            return String.valueOf(this.getBuildCount());
        }
        return "";
    }

    public String getDayCountString() {
        if (this.isDayCountDefined()) {
            return String.valueOf(this.getDayCount());
        }
        return "";
    }

    public void doFixed(StaplerRequest request, StaplerResponse response) {
        this.drawFixed(request, response, Mode.PNG);
    }

    public void doFixedMap(StaplerRequest request, StaplerResponse response) {
        this.drawFixed(request, response, Mode.MAP);
    }

    private void drawFixed(StaplerRequest request, StaplerResponse response, Mode mode) {
        this.drawGraph(request, response, mode, (BuildResultGraph)new NewVersusFixedGraph());
    }

    public void doDifference(StaplerRequest request, StaplerResponse response) {
        this.drawDifference(request, response, Mode.PNG);
    }

    public void doDifferenceMap(StaplerRequest request, StaplerResponse response) {
        this.drawDifference(request, response, Mode.MAP);
    }

    private void drawDifference(StaplerRequest request, StaplerResponse response, Mode mode) {
        this.drawGraph(request, response, mode, (BuildResultGraph)new DifferenceGraph());
    }

    public void doPriority(StaplerRequest request, StaplerResponse response) {
        this.drawPriority(request, response, Mode.PNG);
    }

    public void doPriorityMap(StaplerRequest request, StaplerResponse response) {
        this.drawPriority(request, response, Mode.MAP);
    }

    private void drawPriority(StaplerRequest request, StaplerResponse response, Mode mode) {
        this.drawGraph(request, response, mode, (BuildResultGraph)new PriorityGraph());
    }

    public boolean isHealthGraphAvailable() {
        return this.healthDescriptor.isEnabled();
    }

    public void doHealth(StaplerRequest request, StaplerResponse response) {
        this.drawHealth(request, response, Mode.PNG);
    }

    public void doHealthMap(StaplerRequest request, StaplerResponse response) {
        this.drawHealth(request, response, Mode.MAP);
    }

    private void drawHealth(StaplerRequest request, StaplerResponse response, Mode mode) {
        this.drawGraph(request, response, mode, (BuildResultGraph)new HealthGraph(this.healthDescriptor));
    }

    private void drawGraph(StaplerRequest request, StaplerResponse response, Mode mode, BuildResultGraph buildResultGraph) {
        buildResultGraph.setRootUrl("../../");
        if (this.hasMeaningfulGraph()) {
            JFreeChart graph = buildResultGraph.create((GraphConfiguration)this, this.lastAction, this.pluginName);
            this.generateGraph(request, response, graph, mode);
        }
    }

    private void generateGraph(StaplerRequest request, StaplerResponse response, JFreeChart graph, Mode mode) {
        try {
            if (mode == Mode.PNG) {
                ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)graph, (int)500, (int)200);
            } else {
                ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)graph, (int)500, (int)200);
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Can't create graph: " + request, exception);
        }
    }
}

