/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry.util;

import hudson.plugins.dry.util.Messages;
import hudson.plugins.dry.util.SingleFieldValidator;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class ThresholdValidator
extends SingleFieldValidator {
    public ThresholdValidator(StaplerRequest request, StaplerResponse response) {
        super(request, response);
    }

    public void check(String value) throws IOException, ServletException {
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int integer = Integer.valueOf(value);
                if (integer < 0) {
                    this.error(Messages.FieldValidator_Error_Threshold());
                    return;
                }
            }
            catch (NumberFormatException exception) {
                this.error(Messages.FieldValidator_Error_Threshold());
                return;
            }
        }
        this.ok();
    }

    public static boolean isValid(String threshold) {
        if (StringUtils.isNotBlank((String)threshold)) {
            try {
                return Integer.valueOf(threshold) >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int convert(String threshold) {
        if (ThresholdValidator.isValid((String)threshold) && StringUtils.isNotBlank((String)threshold)) {
            try {
                return Integer.valueOf(threshold);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Not a parsable integer value >= 0: " + threshold);
    }
}

