/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.plugins.dry.DryDescriptor;
import hudson.plugins.dry.DryProjectAction;
import hudson.plugins.dry.DryResult;
import hudson.plugins.dry.DryResultAction;
import hudson.plugins.dry.DryResultBuilder;
import hudson.plugins.dry.parser.DuplicationParserRegistry;
import hudson.plugins.dry.util.AnnotationParser;
import hudson.plugins.dry.util.FilesParser;
import hudson.plugins.dry.util.HealthAwarePublisher;
import hudson.plugins.dry.util.HealthDescriptor;
import hudson.plugins.dry.util.ParserResult;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 6711252664481150129L;
    private static final String DEFAULT_PATTERN = "**/cpd.xml";
    public static final DryDescriptor DRY_DESCRIPTOR = new DryDescriptor();
    private final String pattern;

    @DataBoundConstructor
    public DryPublisher(String pattern, String threshold, String healthy, String unHealthy, String height, String thresholdLimit, String defaultEncoding) {
        super(threshold, healthy, unHealthy, height, thresholdLimit, defaultEncoding, "DRY");
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new DryProjectAction(project, this.getTrendHeight());
    }

    public ParserResult perform(AbstractBuild<?, ?> build, PrintStream logger) throws InterruptedException, IOException {
        this.log(logger, "Collecting duplicate code analysis files...");
        FilesParser dryCollector = new FilesParser(logger, StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), (AnnotationParser)new DuplicationParserRegistry(), this.isMavenBuild(build), this.isAntBuild(build));
        ParserResult project = (ParserResult)build.getProject().getWorkspace().act((FilePath.FileCallable)dryCollector);
        DryResult result = new DryResultBuilder().build(build, project, this.getDefaultEncoding());
        build.getActions().add(new DryResultAction(build, (HealthDescriptor)this, result));
        return project;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DRY_DESCRIPTOR;
    }
}

