/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import hudson.model.AbstractBuild;
import hudson.plugins.dry.DryResultAction;
import hudson.plugins.dry.Messages;
import hudson.plugins.dry.ResultSummary;
import hudson.plugins.dry.parser.DuplicateCode;
import hudson.plugins.dry.util.AnnotationsBuildResult;
import hudson.plugins.dry.util.ParserResult;
import hudson.plugins.dry.util.model.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryResult
extends AnnotationsBuildResult {
    private static final long serialVersionUID = 2768250056765266658L;

    public DryResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
    }

    public DryResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, DryResult previous) {
        super(build, defaultEncoding, result, previous);
    }

    public String getSummary() {
        return ResultSummary.createSummary(this);
    }

    @Override
    public String getDetails() {
        String message = ResultSummary.createDeltaMessage(this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            message = message + "<li>" + Messages.DRY_ResultAction_NoWarningsSince(this.getZeroWarningsSinceBuild()) + "</li>";
            message = message + this.createHighScoreMessage();
        }
        return message;
    }

    private String createHighScoreMessage() {
        if (this.isNewZeroWarningsHighScore()) {
            long days = DryResult.getDays(this.getZeroWarningsHighScore());
            if (days == 1L) {
                return "<li>" + Messages.DRY_ResultAction_OneHighScore() + "</li>";
            }
            return "<li>" + Messages.DRY_ResultAction_MultipleHighScore(days) + "</li>";
        }
        long days = DryResult.getDays(this.getHighScoreGap());
        if (days == 1L) {
            return "<li>" + Messages.DRY_ResultAction_OneNoHighScore() + "</li>";
        }
        return "<li>" + Messages.DRY_ResultAction_MultipleNoHighScore(days) + "</li>";
    }

    @Override
    protected String getSerializationFileName() {
        return "dry-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.DRY_ProjectAction_Name();
    }

    @Override
    public JavaProject getPreviousResult() {
        DryResultAction action = (DryResultAction)this.getOwner().getAction(DryResultAction.class);
        if (action.hasPreviousResultAction()) {
            return ((DryResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return null;
    }

    @Override
    public boolean hasPreviousResult() {
        return ((DryResultAction)this.getOwner().getAction(DryResultAction.class)).hasPreviousResultAction();
    }

    static {
        XSTREAM.alias("dry", DuplicateCode.class);
    }
}

