/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.plugins.dry.util.FileFinder;
import hudson.plugins.dry.util.Messages;
import hudson.plugins.dry.util.model.FileAnnotation;
import hudson.plugins.dry.util.model.Priority;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserResult
implements Serializable {
    private static final long serialVersionUID = -8414545334379193330L;
    @SuppressWarnings(value={"Se"})
    private final Set<FileAnnotation> annotations = new HashSet<FileAnnotation>();
    @SuppressWarnings(value={"Se"})
    private final List<String> errorMessages = new ArrayList<String>();
    @SuppressWarnings(value={"Se"})
    private final Map<Priority, Integer> annotationCountByPriority = new HashMap<Priority, Integer>();
    @SuppressWarnings(value={"Se"})
    private final Set<String> modules = new HashSet<String>();
    private final FilePath workspace;
    @SuppressWarnings(value={"Se"})
    private final Map<String, String> fileNameCache = new HashMap<String, String>();

    public ParserResult() {
        this(null);
    }

    public ParserResult(FilePath workspace) {
        this.workspace = workspace;
        Priority[] priorities = Priority.values();
        for (int priority = 0; priority < priorities.length; ++priority) {
            this.annotationCountByPriority.put(priorities[priority], 0);
        }
    }

    private void findRelativeFile(FileAnnotation annotation) {
        try {
            if (this.workspace != null && this.hasRelativeFileName(annotation)) {
                if (this.fileNameCache.isEmpty()) {
                    this.populateFileNameCache();
                }
                if (this.fileNameCache.containsKey(annotation.getFileName())) {
                    annotation.setFileName(this.workspace.getRemote() + "/" + this.fileNameCache.get(annotation.getFileName()));
                }
            }
        }
        catch (IOException exception) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void populateFileNameCache() throws IOException, InterruptedException {
        String[] allFiles;
        for (String file : allFiles = (String[])this.workspace.act((FilePath.FileCallable)new FileFinder("**/*"))) {
            String fileName = new File(file).getName();
            if (this.fileNameCache.containsKey(fileName)) {
                this.fileNameCache.remove(fileName);
                continue;
            }
            this.fileNameCache.put(fileName, file);
        }
    }

    private boolean hasRelativeFileName(FileAnnotation annotation) {
        String fileName = annotation.getFileName();
        return !fileName.startsWith("/") && !fileName.contains(":");
    }

    public void addAnnotation(FileAnnotation annotation) {
        if (!this.annotations.contains(annotation)) {
            this.findRelativeFile(annotation);
            this.annotations.add(annotation);
            Integer count = this.annotationCountByPriority.get((Object)annotation.getPriority());
            this.annotationCountByPriority.put(annotation.getPriority(), count + 1);
        }
    }

    public final void addAnnotations(Collection<? extends FileAnnotation> newAnnotations) {
        for (FileAnnotation fileAnnotation : newAnnotations) {
            this.addAnnotation(fileAnnotation);
        }
    }

    public final void addAnnotations(FileAnnotation[] newAnnotations) {
        this.addAnnotations(Arrays.asList(newAnnotations));
    }

    public void addErrorMessage(String module, String message) {
        this.errorMessages.add(Messages.Result_Error_ModuleErrorMessage(module, message));
    }

    public void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    public void addErrors(List<String> errors) {
        this.errorMessages.addAll(errors);
    }

    public Collection<String> getErrorMessages() {
        return Collections.unmodifiableCollection(this.errorMessages);
    }

    public Collection<FileAnnotation> getAnnotations() {
        return Collections.unmodifiableCollection(this.annotations);
    }

    public int getNumberOfAnnotations() {
        return this.annotations.size();
    }

    public int getNumberOfAnnotations(Priority priority) {
        return this.annotationCountByPriority.get((Object)priority);
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty();
    }

    public boolean hasAnnotations(Priority priority) {
        return this.annotationCountByPriority.get((Object)priority) > 0;
    }

    public boolean hasNoAnnotations() {
        return !this.hasAnnotations();
    }

    public boolean hasNoAnnotations(Priority priority) {
        return !this.hasAnnotations(priority);
    }

    public int getNumberOfModules() {
        return this.modules.size();
    }

    public Set<String> getModules() {
        return Collections.unmodifiableSet(this.modules);
    }

    public void addModule(String moduleName) {
        this.modules.add(moduleName);
    }

    public void addModules(Collection<String> additionalModules) {
        this.modules.addAll(additionalModules);
    }
}

