/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import hudson.model.AbstractBuild;
import hudson.plugins.dry.DryResultAction;
import hudson.plugins.dry.Messages;
import hudson.plugins.dry.ResultSummary;
import hudson.plugins.dry.parser.DuplicateCode;
import hudson.plugins.dry.util.BuildResult;
import hudson.plugins.dry.util.ParserResult;
import hudson.plugins.dry.util.model.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DryResult
extends BuildResult {
    private static final long serialVersionUID = 2768250056765266658L;

    public DryResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
    }

    public DryResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, DryResult previous) {
        super(build, defaultEncoding, result, (BuildResult)previous);
    }

    public String getSummary() {
        return ResultSummary.createSummary((DryResult)this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage((DryResult)this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            message = message + "<li>" + Messages.DRY_ResultAction_NoWarningsSince((Object)this.getZeroWarningsSinceBuild()) + "</li>";
            message = message + this.createHighScoreMessage();
        }
        return message;
    }

    private String createHighScoreMessage() {
        if (this.isNewZeroWarningsHighScore()) {
            long days = DryResult.getDays((long)this.getZeroWarningsHighScore());
            if (days == 1L) {
                return "<li>" + Messages.DRY_ResultAction_OneHighScore() + "</li>";
            }
            return "<li>" + Messages.DRY_ResultAction_MultipleHighScore((Object)days) + "</li>";
        }
        long days = DryResult.getDays((long)this.getHighScoreGap());
        if (days == 1L) {
            return "<li>" + Messages.DRY_ResultAction_OneNoHighScore() + "</li>";
        }
        return "<li>" + Messages.DRY_ResultAction_MultipleNoHighScore((Object)days) + "</li>";
    }

    protected String getSerializationFileName() {
        return "dry-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.DRY_ProjectAction_Name();
    }

    public JavaProject getPreviousResult() {
        DryResultAction action = (DryResultAction)this.getOwner().getAction(DryResultAction.class);
        if (action.hasPreviousResultAction()) {
            return ((DryResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return null;
    }

    public boolean hasPreviousResult() {
        return ((DryResultAction)this.getOwner().getAction(DryResultAction.class)).hasPreviousResultAction();
    }

    static {
        XSTREAM.alias("dry", DuplicateCode.class);
    }
}

