/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry.util;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.dry.util.AbortException;
import hudson.plugins.dry.util.BuildResult;
import hudson.plugins.dry.util.BuildResultEvaluator;
import hudson.plugins.dry.util.HealthDescriptor;
import hudson.plugins.dry.util.ParserResult;
import hudson.plugins.dry.util.PluginLogger;
import hudson.plugins.dry.util.TrendReportHeightValidator;
import hudson.plugins.dry.util.model.DefaultAnnotationContainer;
import hudson.plugins.dry.util.model.FileAnnotation;
import hudson.plugins.dry.util.model.Priority;
import hudson.plugins.dry.util.model.WorkspaceFile;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Ant;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HealthAwarePublisher
extends Publisher
implements HealthDescriptor {
    private static final long serialVersionUID = -7945220365563528457L;
    private static final String DEFAULT_PRIORITY_THRESHOLD_LIMIT = "low";
    private final String threshold;
    private final String newThreshold;
    private final String failureThreshold;
    private final String newFailureThreshold;
    private boolean thresholdEnabled;
    private int minimumAnnotations;
    private final String healthy;
    private final String unHealthy;
    private int healthyAnnotations;
    private int unHealthyAnnotations;
    private boolean healthyReportEnabled;
    private final String height;
    private final String pluginName;
    private String thresholdLimit;
    private final String defaultEncoding;

    public HealthAwarePublisher(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String height, String thresholdLimit, String defaultEncoding, String pluginName) {
        this.threshold = threshold;
        this.newThreshold = newThreshold;
        this.failureThreshold = failureThreshold;
        this.newFailureThreshold = newFailureThreshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.height = height;
        this.thresholdLimit = thresholdLimit;
        this.defaultEncoding = defaultEncoding;
        this.pluginName = "[" + pluginName + "] ";
        this.validateThreshold(threshold);
        this.validateHealthiness(healthy, unHealthy);
        if (StringUtils.isBlank((String)thresholdLimit)) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
    }

    private void validateHealthiness(String healthyParameter, String unHealthyParameter) {
        if (!StringUtils.isEmpty((String)healthyParameter) && !StringUtils.isEmpty((String)unHealthyParameter)) {
            try {
                this.healthyAnnotations = Integer.valueOf(healthyParameter);
                this.unHealthyAnnotations = Integer.valueOf(unHealthyParameter);
                if (this.healthyAnnotations >= 0 && this.unHealthyAnnotations > this.healthyAnnotations) {
                    this.healthyReportEnabled = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void validateThreshold(String thresholdParameter) {
        if (!StringUtils.isEmpty((String)thresholdParameter)) {
            try {
                this.minimumAnnotations = Integer.valueOf(thresholdParameter);
                if (this.minimumAnnotations >= 0) {
                    this.thresholdEnabled = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected Object readResolve() {
        if (this.thresholdLimit == null) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
        return this;
    }

    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.canContinue(build.getResult())) {
            PluginLogger logger = new PluginLogger(listener.getLogger(), this.pluginName);
            try {
                BuildResult annotationsResult = this.perform(build, logger);
                ParserResult result = new ParserResult(annotationsResult.getAnnotations());
                ParserResult newResult = new ParserResult(annotationsResult.getNewWarnings());
                Result buildResult = new BuildResultEvaluator().evaluateBuildResult(logger, this.getMinimumPriority(), result, this.getThreshold(), this.getFailureThreshold(), newResult, this.getNewThreshold(), this.getNewFailureThreshold());
                if (buildResult != Result.SUCCESS) {
                    build.setResult(buildResult);
                }
                if (build.getProject().getWorkspace().isRemote()) {
                    this.copyFilesFromSlaveToMaster(build.getRootDir(), launcher.getChannel(), annotationsResult.getAnnotations());
                }
            }
            catch (AbortException exception) {
                logger.log(exception);
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        return true;
    }

    private void copyFilesFromSlaveToMaster(File rootDir, VirtualChannel channel, Collection<FileAnnotation> annotations) throws IOException, FileNotFoundException, InterruptedException {
        File directory = new File(rootDir, "workspace-files");
        if (!directory.exists() && !directory.mkdir()) {
            throw new IOException("Can't create directory for workspace files that contain annotations: " + directory.getAbsolutePath());
        }
        DefaultAnnotationContainer container = new DefaultAnnotationContainer(annotations);
        for (WorkspaceFile file : container.getFiles()) {
            File masterFile = new File(directory, file.getTempName());
            if (masterFile.exists()) continue;
            try {
                FileOutputStream outputStream = new FileOutputStream(masterFile);
                new FilePath(channel, file.getName()).copyTo((OutputStream)outputStream);
            }
            catch (IOException exception) {
                this.logExceptionToFile(exception, masterFile, file.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void logExceptionToFile(IOException exception, File masterFile, String slaveFileName) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(masterFile);
            String message = "Can't copy file from slave to master: slave=" + slaveFileName + ", master=" + masterFile.getAbsolutePath();
            exception.printStackTrace(new PrintStream(outputStream));
            IOUtils.write((String)message, (OutputStream)outputStream);
        }
        catch (IOException error) {
            IOUtils.closeQuietly((OutputStream)outputStream);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    protected abstract BuildResult perform(AbstractBuild<?, ?> var1, PluginLogger var2) throws InterruptedException, IOException;

    @Override
    public boolean isThresholdEnabled() {
        return this.thresholdEnabled;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getNewThreshold() {
        return this.newThreshold;
    }

    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    public String getNewFailureThreshold() {
        return this.newFailureThreshold;
    }

    @Override
    public int getMinimumAnnotations() {
        return this.minimumAnnotations;
    }

    @Override
    public boolean isHealthyReportEnabled() {
        return this.healthyReportEnabled;
    }

    public String getHealthy() {
        return this.healthy;
    }

    @Override
    public int getHealthyAnnotations() {
        return this.healthyAnnotations;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    @Override
    public int getUnHealthyAnnotations() {
        return this.unHealthyAnnotations;
    }

    public String getHeight() {
        return this.height;
    }

    public int getTrendHeight() {
        return TrendReportHeightValidator.defaultHeight(this.height);
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    protected boolean isMavenBuild(AbstractBuild<?, ?> build) {
        if (build.getProject() instanceof Project) {
            Project project = (Project)build.getProject();
            for (Builder builder : project.getBuilders()) {
                if (!(builder instanceof Maven)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAntBuild(AbstractBuild<?, ?> build) {
        if (build.getProject() instanceof Project) {
            Project project = (Project)build.getProject();
            for (Builder builder : project.getBuilders()) {
                if (!(builder instanceof Ant)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Priority getMinimumPriority() {
        return Priority.valueOf(StringUtils.upperCase((String)this.getThresholdLimit()));
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }
}

