/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwareMavenReporter;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.PluginDescriptor;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.dry.DryProjectAction;
import hudson.plugins.dry.DryPublisher;
import hudson.plugins.dry.DryReporterDescriptor;
import hudson.plugins.dry.DryResult;
import hudson.plugins.dry.DryResultBuilder;
import hudson.plugins.dry.MavenDryResultAction;
import hudson.plugins.dry.parser.DuplicationParserRegistry;
import java.io.IOException;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryReporter
extends HealthAwareMavenReporter {
    private static final long serialVersionUID = 2272875032054063496L;
    public static final DryReporterDescriptor DRY_SCANNER_DESCRIPTOR = new DryReporterDescriptor((PluginDescriptor)DryPublisher.DRY_DESCRIPTOR);
    private static final String DRY_XML_FILE = "cpd.xml";

    @DataBoundConstructor
    public DryReporter(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, "DRY");
    }

    protected boolean acceptGoal(String goal) {
        return "cpd".equals(goal) || "site".equals(goal);
    }

    public ParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PluginLogger logger) throws InterruptedException, IOException {
        FilesParser dryCollector = new FilesParser(logger, DRY_XML_FILE, (AnnotationParser)new DuplicationParserRegistry(), true, false);
        return (ParserResult)this.getTargetPath(pom).act((FilePath.FileCallable)dryCollector);
    }

    protected BuildResult persistResult(ParserResult project, MavenBuild build) {
        DryResult result = new DryResultBuilder().build((AbstractBuild)build, project, this.getDefaultEncoding());
        build.getActions().add(new MavenDryResultAction((AbstractBuild)build, (HealthDescriptor)this, this.getDefaultEncoding(), result));
        build.registerAsProjectAction((MavenReporter)this);
        return result;
    }

    public Action getProjectAction(MavenModule module) {
        return new DryProjectAction((AbstractProject)module);
    }

    protected Class<? extends Action> getResultActionClass() {
        return MavenDryResultAction.class;
    }

    public MavenReporterDescriptor getDescriptor() {
        return DRY_SCANNER_DESCRIPTOR;
    }
}

