/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry.parser;

import de.java2html.converter.JavaSource2HTMLConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.util.IllegalConfigurationException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.analysis.util.model.AbstractAnnotation;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.LineRange;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.dry.Messages;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateCode
extends AbstractAnnotation {
    private static final long serialVersionUID = -6231614169627992548L;
    @SuppressWarnings(value={"Se"})
    private final Set<DuplicateCode> links = new HashSet();
    private String sourceCode;

    public DuplicateCode(int firstLine, int numberOfLines, String fileName) {
        super(Messages.DRY_Warning_Message((Object)numberOfLines), firstLine, firstLine + numberOfLines - 1, "Duplicate Code", "");
        this.setFileName(fileName);
        if (numberOfLines > 50) {
            this.setPriority(Priority.HIGH);
        } else if (numberOfLines > 25) {
            this.setPriority(Priority.NORMAL);
        } else {
            this.setPriority(Priority.LOW);
        }
    }

    public int getNumberOfLines() {
        return ((LineRange)this.getLineRanges().iterator().next()).getEnd() - this.getPrimaryLineNumber() + 1;
    }

    public int size() {
        return this.getNumberOfLines();
    }

    public int length() {
        return this.getNumberOfLines();
    }

    public String getToolTip() {
        return "";
    }

    public void linkTo(ArrayList<DuplicateCode> codeBlocks) {
        this.links.addAll(codeBlocks);
        this.links.remove(this);
    }

    public Collection<DuplicateCode> getLinks() {
        return Collections.unmodifiableCollection(this.links);
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public String getFormattedSourceCode() {
        try {
            JavaSource source = new JavaSourceParser().parse((Reader)new StringReader(this.sourceCode));
            JavaSource2HTMLConverter converter = new JavaSource2HTMLConverter();
            StringWriter writer = new StringWriter();
            JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
            options.setShowLineNumbers(false);
            options.setAddLineAnchors(false);
            converter.convert(source, options, (Writer)writer);
            return writer.toString();
        }
        catch (IllegalConfigurationException exception) {
            return this.sourceCode;
        }
        catch (IOException exception) {
            return this.sourceCode;
        }
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sourceCode == null ? 0 : this.sourceCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DuplicateCode other = (DuplicateCode)obj;
        return !(this.sourceCode == null ? other.sourceCode != null : !this.sourceCode.equals(other.sourceCode));
    }

    public FileAnnotation getLink(long linkHashCode) {
        for (DuplicateCode link : this.links) {
            if (link.getKey() != linkHashCode) continue;
            return link;
        }
        throw new NoSuchElementException("Linked annotation not found: key=" + linkHashCode);
    }
}

