/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import com.thoughtworks.xstream.XStream;
import hudson.model.AbstractBuild;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.dry.DryResultAction;
import hudson.plugins.dry.Messages;
import hudson.plugins.dry.ResultSummary;
import hudson.plugins.dry.parser.DuplicateCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryResult
extends BuildResult {
    private static final long serialVersionUID = 2768250056765266658L;

    public DryResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
    }

    public DryResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, DryResult previous) {
        super(build, defaultEncoding, result, (BuildResult)previous);
    }

    protected void configure(XStream xstream) {
        xstream.alias("dry", DuplicateCode.class);
    }

    public String getSummary() {
        return ResultSummary.createSummary(this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage(this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            message = message + "<li>" + Messages.DRY_ResultAction_NoWarningsSince(this.getZeroWarningsSinceBuild()) + "</li>";
            message = message + this.createHighScoreMessage();
        }
        return message;
    }

    private String createHighScoreMessage() {
        if (this.isNewZeroWarningsHighScore()) {
            long days = DryResult.getDays((long)this.getZeroWarningsHighScore());
            if (days == 1L) {
                return "<li>" + Messages.DRY_ResultAction_OneHighScore() + "</li>";
            }
            return "<li>" + Messages.DRY_ResultAction_MultipleHighScore(days) + "</li>";
        }
        long days = DryResult.getDays((long)this.getHighScoreGap());
        if (days == 1L) {
            return "<li>" + Messages.DRY_ResultAction_OneNoHighScore() + "</li>";
        }
        return "<li>" + Messages.DRY_ResultAction_MultipleNoHighScore(days) + "</li>";
    }

    protected String getSerializationFileName() {
        return "dry-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.DRY_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return DryResultAction.class;
    }
}

