/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry.parser.cpd;

import hudson.plugins.analysis.util.JavaPackageDetector;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.dry.parser.AbstractDryParser;
import hudson.plugins.dry.parser.DuplicateCode;
import hudson.plugins.dry.parser.cpd.Duplication;
import hudson.plugins.dry.parser.cpd.SourceFile;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpdParser
extends AbstractDryParser {
    private static final long serialVersionUID = 6507147028628714706L;

    @Override
    public boolean accepts(InputStream file) {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(CpdParser.class.getClassLoader());
            String duplicationXPath = "*/pmd-cpd";
            digester.addObjectCreate(duplicationXPath, String.class);
            Object result = digester.parse(file);
            if (result instanceof String) {
                return true;
            }
        }
        catch (IOException exception) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Collection<FileAnnotation> parse(InputStream file, String moduleName) throws InvocationTargetException {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(CpdParser.class.getClassLoader());
            ArrayList<Duplication> duplications = new ArrayList<Duplication>();
            digester.push(duplications);
            String duplicationXPath = "*/pmd-cpd/duplication";
            digester.addObjectCreate(duplicationXPath, Duplication.class);
            digester.addSetProperties(duplicationXPath);
            digester.addCallMethod(duplicationXPath + "/codefragment", "setCodeFragment", 0);
            digester.addSetNext(duplicationXPath, "add");
            String fileXPath = duplicationXPath + "/file";
            digester.addObjectCreate(fileXPath, SourceFile.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addFile", SourceFile.class.getName());
            Object result = digester.parse(file);
            if (result != duplications) {
                throw new SAXException("Input stream is not a valid CPD file.");
            }
            return this.convert(duplications, moduleName);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SAXException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    private Collection<FileAnnotation> convert(ArrayList<Duplication> duplications, String moduleName) {
        JavaPackageDetector javaPackageDetector = new JavaPackageDetector();
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        for (Duplication duplication : duplications) {
            ArrayList<DuplicateCode> codeBlocks = new ArrayList<DuplicateCode>();
            for (SourceFile file : duplication.getFiles()) {
                DuplicateCode annotation = new DuplicateCode(file.getLine(), duplication.getLines(), file.getPath());
                annotation.setSourceCode(duplication.getCodeFragment());
                annotation.setModuleName(moduleName);
                codeBlocks.add(annotation);
            }
            for (DuplicateCode block : codeBlocks) {
                block.linkTo(codeBlocks);
                String packageName = javaPackageDetector.detectPackageName(block.getFileName());
                block.setPackageName(packageName);
            }
            annotations.addAll(codeBlocks);
        }
        return annotations;
    }
}

