/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import hudson.model.AbstractBuild;
import hudson.plugins.analysis.util.model.AnnotationContainer;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.views.DetailFactory;
import hudson.plugins.analysis.views.SourceDetail;
import hudson.plugins.analysis.views.TabDetail;
import hudson.plugins.dry.DryTabDetail;
import hudson.plugins.dry.parser.DuplicateCode;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryDetailBuilder
extends DetailFactory {
    public Object createDetails(String link, AbstractBuild<?, ?> owner, AnnotationContainer container, String defaultEncoding, String displayName) {
        if (link.startsWith("link.")) {
            String suffix = StringUtils.substringAfter((String)link, (String)"link.");
            String[] fromToStrings = StringUtils.split((String)suffix, (String)".");
            if (fromToStrings.length == 2) {
                return this.createDrySourceDetail(owner, container, defaultEncoding, fromToStrings[0], fromToStrings[1]);
            }
            return null;
        }
        return super.createDetails(link, owner, container, defaultEncoding, displayName);
    }

    private Object createDrySourceDetail(AbstractBuild<?, ?> owner, AnnotationContainer container, String defaultEncoding, String fromString, String toString) {
        long from = Long.parseLong(fromString);
        long to = Long.parseLong(toString);
        FileAnnotation fromAnnotation = container.getAnnotation(from);
        if (fromAnnotation instanceof DuplicateCode) {
            return new SourceDetail(owner, ((DuplicateCode)fromAnnotation).getLink(to), defaultEncoding);
        }
        return null;
    }

    protected TabDetail createTabDetail(AbstractBuild<?, ?> owner, Collection<FileAnnotation> annotations, String url, String defaultEncoding) {
        return new DryTabDetail(owner, annotations, url, defaultEncoding);
    }
}

