/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import hudson.Extension;
import hudson.plugins.analysis.core.PluginDescriptor;
import hudson.plugins.dry.DryPublisher;
import hudson.plugins.dry.Messages;
import hudson.util.FormValidation;
import org.kohsuke.stapler.QueryParameter;

@Extension(ordinal=100.0)
public final class DryDescriptor
extends PluginDescriptor {
    private static final String PLUGIN_NAME = "dry";
    private static final String ACTION_ICON = "/plugin/dry/icons/dry-24x24.png";

    public DryDescriptor() {
        super(DryPublisher.class);
    }

    public String getDisplayName() {
        return Messages.DRY_Publisher_Name();
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public String getIconUrl() {
        return ACTION_ICON;
    }

    public FormValidation doCheckHighThreshold(@QueryParameter String highThreshold, @QueryParameter String normalThreshold) {
        return this.validate(highThreshold, normalThreshold, Messages.DRY_ValidationError_HighThreshold());
    }

    public FormValidation doCheckNormalThreshold(@QueryParameter String highThreshold, @QueryParameter String normalThreshold) {
        return this.validate(highThreshold, normalThreshold, Messages.DRY_ValidationError_NormalThreshold());
    }

    private FormValidation validate(String highThreshold, String normalThreshold, String message) {
        try {
            int high = Integer.parseInt(highThreshold);
            int normal = Integer.parseInt(normalThreshold);
            if (normal >= 0 && high > normal) {
                return FormValidation.ok();
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return FormValidation.error((String)message);
    }
}

