/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.dry.DryDescriptor;
import hudson.plugins.dry.DryProjectAction;
import hudson.plugins.dry.DryResult;
import hudson.plugins.dry.DryResultAction;
import hudson.plugins.dry.parser.DuplicationParserRegistry;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DryPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 6711252664481150129L;
    private static final String DEFAULT_PATTERN = "**/cpd.xml";
    private final String pattern;
    private final int highThreshold;
    private final int normalThreshold;

    @DataBoundConstructor
    public DryPublisher(String pattern, String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, boolean canRunOnFailed, int highThreshold, int normalThreshold) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, canRunOnFailed, "DRY");
        this.pattern = pattern;
        this.highThreshold = highThreshold;
        this.normalThreshold = normalThreshold;
    }

    public int getHighThreshold() {
        if (this.highThreshold <= 0 || this.highThreshold <= this.normalThreshold) {
            return 50;
        }
        return this.highThreshold;
    }

    public int getNormalThreshold() {
        if (this.normalThreshold <= 0 || this.highThreshold <= this.normalThreshold) {
            return 25;
        }
        return this.normalThreshold;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new DryProjectAction(project);
    }

    public BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        logger.log("Collecting duplicate code analysis files...");
        FilesParser dryCollector = new FilesParser(logger, StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), (AnnotationParser)new DuplicationParserRegistry(this.getNormalThreshold(), this.getHighThreshold()), this.isMavenBuild(build), this.isAntBuild(build));
        ParserResult project = (ParserResult)build.getWorkspace().act((FilePath.FileCallable)dryCollector);
        DryResult result = new DryResult(build, this.getDefaultEncoding(), project);
        build.getActions().add(new DryResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public DryDescriptor getDescriptor() {
        return (DryDescriptor)super.getDescriptor();
    }
}

