/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dry;

import hudson.Extension;
import hudson.maven.MavenReporter;
import hudson.model.Descriptor;
import hudson.plugins.analysis.core.PluginDescriptor;
import hudson.plugins.analysis.core.ReporterDescriptor;
import hudson.plugins.dry.DryDescriptor;
import hudson.plugins.dry.DryReporter;
import hudson.plugins.dry.Messages;
import hudson.util.FormValidation;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=100.0)
public class DryReporterDescriptor
extends ReporterDescriptor {
    public DryReporterDescriptor() {
        super(DryReporter.class, (PluginDescriptor)new DryDescriptor());
    }

    public MavenReporter newInstance(StaplerRequest request, JSONObject formData) throws Descriptor.FormException {
        return (MavenReporter)request.bindJSON(DryReporter.class, formData);
    }

    public FormValidation doCheckHighThreshold(@QueryParameter String highThreshold, @QueryParameter String normalThreshold) {
        return this.validate(highThreshold, normalThreshold, Messages.DRY_ValidationError_HighThreshold());
    }

    public FormValidation doCheckNormalThreshold(@QueryParameter String highThreshold, @QueryParameter String normalThreshold) {
        return this.validate(highThreshold, normalThreshold, Messages.DRY_ValidationError_NormalThreshold());
    }

    private FormValidation validate(String highThreshold, String normalThreshold, String message) {
        try {
            int high = Integer.parseInt(highThreshold);
            int normal = Integer.parseInt(normalThreshold);
            if (normal >= 0 && high > normal) {
                return FormValidation.ok();
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return FormValidation.error((String)message);
    }
}

