/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dumpinfo;

import hudson.Launcher;
import hudson.PluginWrapper;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.plugins.dumpinfo.MessagesUtils;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;

public final class DumpInfoBuildWrapper
extends BuildWrapper {
    private final boolean dumpComputers;
    private final boolean dumpJdks;
    private final boolean dumpPlugins;

    @DataBoundConstructor
    public DumpInfoBuildWrapper(boolean dumpComputers, boolean dumpJdks, boolean dumpPlugins) {
        this.dumpComputers = dumpComputers;
        this.dumpJdks = dumpJdks;
        this.dumpPlugins = dumpPlugins;
    }

    public boolean isDumpComputers() {
        return this.dumpComputers;
    }

    public boolean isDumpJdks() {
        return this.dumpJdks;
    }

    public boolean isDumpPlugins() {
        return this.dumpPlugins;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        Hudson hudson = Hudson.getInstance();
        PrintStream logger = listener.getLogger();
        logger.println(MessagesUtils.format((Hudson)Hudson.getInstance()));
        if (this.dumpComputers) {
            for (Computer computer : hudson.getComputers()) {
                logger.println(MessagesUtils.format((Computer)computer));
            }
        }
        if (this.dumpJdks) {
            for (JDK jdk : hudson.getJDKs()) {
                logger.println(MessagesUtils.format((JDK)jdk));
            }
        }
        if (this.dumpPlugins) {
            for (PluginWrapper plugin : hudson.getPluginManager().getPlugins()) {
                logger.println(MessagesUtils.format((PluginWrapper)plugin));
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

