/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dumpinfo;

import hudson.PluginWrapper;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.plugins.dumpinfo.ComputerUtils;
import hudson.plugins.dumpinfo.Messages;

public final class MessagesUtils {
    public static String format(Computer computer) {
        if (computer == null) {
            return null;
        }
        if (computer.isOnline()) {
            return Messages.DumpInfo_Computer_Online(computer.getDisplayName(), computer.getNumExecutors(), ComputerUtils.getRootUrl(computer));
        }
        return Messages.DumpInfo_Computer_Offline(computer.getDisplayName(), computer.getNumExecutors(), ComputerUtils.getRootUrl(computer));
    }

    public static String format(Hudson hudson) {
        if (hudson == null) {
            return null;
        }
        return Messages.DumpInfo_Hudson(hudson.getDisplayName(), Hudson.getVersion());
    }

    public static String format(JDK jdk) {
        if (jdk == null) {
            return null;
        }
        return Messages.DumpInfo_Tool_JDK(jdk.getName(), jdk.getHome());
    }

    public static String format(PluginWrapper pluginWrapper) {
        if (pluginWrapper == null) {
            return null;
        }
        return Messages.DumpInfo_Plugin(pluginWrapper.getLongName(), pluginWrapper.getVersion(), pluginWrapper.getUrl());
    }

    private MessagesUtils() {
    }
}

