// CHECKSTYLE:OFF

package hudson.plugins.dumpinfo;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Found environment variable: {0}={1}
     * 
     */
    public static String DumpInfo_Environment_Variable(Object arg1, Object arg2) {
        return holder.format("DumpInfo.Environment.Variable", arg1, arg2);
    }

    /**
     * Found environment variable: {0}={1}
     * 
     */
    public static Localizable _DumpInfo_Environment_Variable(Object arg1, Object arg2) {
        return new Localizable(holder, "DumpInfo.Environment.Variable", arg1, arg2);
    }

    /**
     * Found computer: {0} (ONLINE) with {1} executors - {2}
     * 
     */
    public static String DumpInfo_Computer_Online(Object arg1, Object arg2, Object arg3) {
        return holder.format("DumpInfo.Computer.Online", arg1, arg2, arg3);
    }

    /**
     * Found computer: {0} (ONLINE) with {1} executors - {2}
     * 
     */
    public static Localizable _DumpInfo_Computer_Online(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "DumpInfo.Computer.Online", arg1, arg2, arg3);
    }

    /**
     * Found computer: {0} (OFFLINE) with {1} executors - {2}
     * 
     */
    public static String DumpInfo_Computer_Offline(Object arg1, Object arg2, Object arg3) {
        return holder.format("DumpInfo.Computer.Offline", arg1, arg2, arg3);
    }

    /**
     * Found computer: {0} (OFFLINE) with {1} executors - {2}
     * 
     */
    public static Localizable _DumpInfo_Computer_Offline(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "DumpInfo.Computer.Offline", arg1, arg2, arg3);
    }

    /**
     * Dump Hudson-specific information to job log
     * 
     */
    public static String DumpInfo_DisplayName() {
        return holder.format("DumpInfo.DisplayName");
    }

    /**
     * Dump Hudson-specific information to job log
     * 
     */
    public static Localizable _DumpInfo_DisplayName() {
        return new Localizable(holder, "DumpInfo.DisplayName");
    }

    /**
     * Found system property: {0}={1}
     * 
     */
    public static String DumpInfo_System_Property(Object arg1, Object arg2) {
        return holder.format("DumpInfo.System.Property", arg1, arg2);
    }

    /**
     * Found system property: {0}={1}
     * 
     */
    public static Localizable _DumpInfo_System_Property(Object arg1, Object arg2) {
        return new Localizable(holder, "DumpInfo.System.Property", arg1, arg2);
    }

    /**
     * Found plugin: {0} v{1} - {2}
     * 
     */
    public static String DumpInfo_Plugin(Object arg1, Object arg2, Object arg3) {
        return holder.format("DumpInfo.Plugin", arg1, arg2, arg3);
    }

    /**
     * Found plugin: {0} v{1} - {2}
     * 
     */
    public static Localizable _DumpInfo_Plugin(Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "DumpInfo.Plugin", arg1, arg2, arg3);
    }

    /**
     * Found Hudson: {0} v{1}
     * 
     */
    public static String DumpInfo_Hudson(Object arg1, Object arg2) {
        return holder.format("DumpInfo.Hudson", arg1, arg2);
    }

    /**
     * Found Hudson: {0} v{1}
     * 
     */
    public static Localizable _DumpInfo_Hudson(Object arg1, Object arg2) {
        return new Localizable(holder, "DumpInfo.Hudson", arg1, arg2);
    }

    /**
     * Found JDK: {0} at {1}
     * 
     */
    public static String DumpInfo_Tool_JDK(Object arg1, Object arg2) {
        return holder.format("DumpInfo.Tool.JDK", arg1, arg2);
    }

    /**
     * Found JDK: {0} at {1}
     * 
     */
    public static Localizable _DumpInfo_Tool_JDK(Object arg1, Object arg2) {
        return new Localizable(holder, "DumpInfo.Tool.JDK", arg1, arg2);
    }

}
