/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dumpinfo;

import hudson.Launcher;
import hudson.PluginWrapper;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.plugins.dumpinfo.MessagesUtils;
import hudson.plugins.dumpinfo.SystemUtils;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

public final class DumpInfoBuildWrapper
extends BuildWrapper {
    private final boolean dumpComputers;
    private final boolean dumpJdks;
    private final boolean dumpPlugins;
    private final boolean dumpSystemProperties;
    private final boolean dumpEnvironmentVariables;

    @DataBoundConstructor
    public DumpInfoBuildWrapper(boolean dumpComputers, boolean dumpJdks, boolean dumpPlugins, boolean dumpSystemProperties, boolean dumpEnvironmentVariables) {
        this.dumpComputers = dumpComputers;
        this.dumpJdks = dumpJdks;
        this.dumpPlugins = dumpPlugins;
        this.dumpSystemProperties = dumpSystemProperties;
        this.dumpEnvironmentVariables = dumpEnvironmentVariables;
    }

    public boolean isDumpComputers() {
        return this.dumpComputers;
    }

    public boolean isDumpJdks() {
        return this.dumpJdks;
    }

    public boolean isDumpPlugins() {
        return this.dumpPlugins;
    }

    public boolean isDumpSystemProperties() {
        return this.dumpSystemProperties;
    }

    public boolean isDumpEnvironmentVariables() {
        return this.dumpEnvironmentVariables;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        Hudson hudson = Hudson.getInstance();
        PrintStream logger = listener.getLogger();
        logger.println(MessagesUtils.format((Hudson)Hudson.getInstance()));
        if (this.dumpComputers) {
            for (Computer computer : hudson.getComputers()) {
                logger.println(MessagesUtils.format((Computer)computer));
            }
        }
        if (this.dumpJdks) {
            for (JDK jDK : hudson.getJDKs()) {
                logger.println(MessagesUtils.format((JDK)jDK));
            }
        }
        if (this.dumpPlugins) {
            for (PluginWrapper pluginWrapper : hudson.getPluginManager().getPlugins()) {
                logger.println(MessagesUtils.format((PluginWrapper)pluginWrapper));
            }
        }
        if (this.dumpSystemProperties) {
            for (Map.Entry entry : SystemUtils.getSystemProperties().entrySet()) {
                logger.println(MessagesUtils.formatSystemProperty((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
        }
        if (this.dumpEnvironmentVariables) {
            for (Map.Entry entry : SystemUtils.getEnvironmentVariables().entrySet()) {
                logger.println(MessagesUtils.formatEnvironmentVariable((String)((String)entry.getKey()), (String)((String)entry.getValue())));
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

