/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dumpinfo;

import hudson.PluginWrapper;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.plugins.dumpinfo.ComputerUtils;
import hudson.plugins.dumpinfo.Messages;

public final class MessagesUtils {
    public static String format(Computer computer) {
        if (computer == null) {
            return null;
        }
        if (computer.isOnline()) {
            return Messages.DumpInfo_Computer_Online((Object)computer.getDisplayName(), (Object)computer.getNumExecutors(), (Object)ComputerUtils.getRootUrl((Computer)computer));
        }
        return Messages.DumpInfo_Computer_Offline((Object)computer.getDisplayName(), (Object)computer.getNumExecutors(), (Object)ComputerUtils.getRootUrl((Computer)computer));
    }

    public static String format(Hudson hudson) {
        if (hudson == null) {
            return null;
        }
        return Messages.DumpInfo_Hudson((Object)hudson.getDisplayName(), (Object)Hudson.getVersion());
    }

    public static String format(JDK jdk) {
        if (jdk == null) {
            return null;
        }
        return Messages.DumpInfo_Tool_JDK((Object)jdk.getName(), (Object)jdk.getHome());
    }

    public static String format(PluginWrapper pluginWrapper) {
        if (pluginWrapper == null) {
            return null;
        }
        return Messages.DumpInfo_Plugin((Object)pluginWrapper.getLongName(), (Object)pluginWrapper.getVersion(), (Object)pluginWrapper.getUrl());
    }

    public static String formatEnvironmentVariable(String key, String value) {
        if (key == null) {
            return null;
        }
        return Messages.DumpInfo_Environment_Variable((Object)key, (Object)value);
    }

    public static String formatSystemProperty(String key, String value) {
        if (key == null) {
            return null;
        }
        return Messages.DumpInfo_System_Property((Object)key, (Object)value);
    }

    private MessagesUtils() {
    }
}

