/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.easyant;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.plugins.easyant.EasyAntInstallation;
import hudson.plugins.easyant.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyAnt
extends Builder {
    private final String name;
    private final String targets;
    private final String buildFile;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public EasyAnt(String name, String targets, String buildFile) {
        this.name = name;
        this.targets = targets;
        this.buildFile = buildFile;
    }

    public String getName() {
        return this.name;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public EasyAntInstallation getEasyAnt() {
        for (EasyAntInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.name == null || !i.getName().equals(this.name)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Project proj = (Project)build.getProject();
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execName = launcher.isUnix() ? "easyant" : "easyant.bat";
        String normalizedTargets = this.targets.replaceAll("[\t\r\n]+", " ");
        EasyAntInstallation ai = this.getEasyAnt();
        if (ai == null) {
            args.add(execName);
        } else {
            File exec = ai.getExecutable();
            if (!ai.isAvailable()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        }
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized(normalizedTargets);
        EnvVars env = build.getEnvironment();
        if (ai != null) {
            env.put((Object)"EASYANT_HOME", (Object)ai.getEasyantHome());
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        FilePath rootLauncher = null;
        if (this.buildFile != null && this.buildFile.trim().length() != 0) {
            String rootBuildScriptReal = Util.replaceMacro((String)this.buildFile, (Map)env);
            rootLauncher = new FilePath(proj.getModuleRoot(), new File(rootBuildScriptReal).getParent());
        } else {
            rootLauncher = proj.getModuleRoot();
        }
        try {
            int r = launcher.launch(args.toCommandArray(), (Map)env, (OutputStream)listener.getLogger(), rootLauncher).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile EasyAntInstallation[] installations = new EasyAntInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        protected DescriptorImpl(Class<? extends EasyAnt> clazz) {
            super(clazz);
        }

        public String getHelpFile() {
            return "/plugin/easyant/help.html";
        }

        public String getDisplayName() {
            return Messages.EasyAnt_DisplayName();
        }

        public EasyAntInstallation[] getInstallations() {
            return this.installations;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.installations = req.bindJSONToList(EasyAntInstallation.class, json.get("inst")).toArray(new EasyAntInstallation[0]);
            this.save();
            return true;
        }

        public EasyAnt newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (EasyAnt)((Object)req.bindJSON(this.clazz, formData));
        }

        public void doCheckEasyAntHome(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                public void check() throws IOException, ServletException {
                    File f = this.getFileParameter("value");
                    if (!f.isDirectory()) {
                        this.error(f + " is not a directory");
                        return;
                    }
                    if (!new File(f, "bin").exists() && !new File(f, "lib").exists()) {
                        this.error(f + " doesn't look like an EasyAnt directory");
                        return;
                    }
                    if (!new File(f, "bin/easyant").exists()) {
                        this.error(f + " doesn't look like an EasyAnt directory");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }
    }
}

