/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.easyant;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.easyant.EasyAnt;
import hudson.plugins.easyant.EasyAntInstallation;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyAnt
extends Builder {
    private final String name;
    private final String targets;
    private final String buildFile;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public EasyAnt(String name, String targets, String buildFile) {
        this.name = name;
        this.targets = targets;
        this.buildFile = buildFile;
    }

    public String getName() {
        return this.name;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public EasyAntInstallation getEasyAnt() {
        for (EasyAntInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.name == null || !i.getName().equals(this.name)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execName = launcher.isUnix() ? "easyant" : "easyant.bat";
        String normalizedTargets = this.targets.replaceAll("[\t\r\n]+", " ");
        EasyAntInstallation ai = this.getEasyAnt();
        if (ai == null) {
            args.add(execName);
        } else {
            File exec = ai.getExecutable();
            if (!ai.isAvailable()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        }
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized(normalizedTargets);
        EnvVars env = build.getEnvironment((TaskListener)listener);
        if (ai != null) {
            env.put((Object)"EASYANT_HOME", (Object)ai.getEasyantHome());
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        FilePath rootLauncher = null;
        if (this.buildFile != null && this.buildFile.trim().length() != 0) {
            String rootBuildScriptReal = Util.replaceMacro((String)this.buildFile, (Map)env);
            rootLauncher = new FilePath(build.getModuleRoot(), new File(rootBuildScriptReal).getParent());
        } else {
            rootLauncher = build.getModuleRoot();
        }
        try {
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(rootLauncher).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }
}

