/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.easyant;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.easyant.EasyAntInstallation;
import hudson.plugins.easyant.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyAnt
extends Builder {
    private final String name;
    private final String targets;
    private final String buildFile;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public EasyAnt(String name, String targets, String buildFile) {
        this.name = name;
        this.targets = targets;
        this.buildFile = buildFile;
    }

    public String getName() {
        return this.name;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public EasyAntInstallation getEasyAnt() {
        for (EasyAntInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.name == null || !i.getName().equals(this.name)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execName = launcher.isUnix() ? "easyant" : "easyant.bat";
        String normalizedTargets = this.targets.replaceAll("[\t\r\n]+", " ");
        EasyAntInstallation ai = this.getEasyAnt();
        if (ai == null) {
            args.add(execName);
        } else {
            File exec = ai.getExecutable();
            if (!ai.isAvailable()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        }
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized(normalizedTargets);
        EnvVars env = build.getEnvironment((TaskListener)listener);
        if (ai != null) {
            env.put((Object)"EASYANT_HOME", (Object)ai.getEasyantHome());
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        FilePath rootLauncher = null;
        if (this.buildFile != null && this.buildFile.trim().length() != 0) {
            String rootBuildScriptReal = Util.replaceMacro((String)this.buildFile, (Map)env);
            rootLauncher = new FilePath(build.getModuleRoot(), new File(rootBuildScriptReal).getParent());
        } else {
            rootLauncher = build.getModuleRoot();
        }
        try {
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(rootLauncher).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile EasyAntInstallation[] installations = new EasyAntInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        protected DescriptorImpl(Class<? extends EasyAnt> clazz) {
            super(clazz);
        }

        public String getHelpFile() {
            return "/plugin/easyant/help.html";
        }

        public String getDisplayName() {
            return Messages.EasyAnt_DisplayName();
        }

        public EasyAntInstallation[] getInstallations() {
            return this.installations;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.installations = req.bindJSONToList(EasyAntInstallation.class, json.get("inst")).toArray(new EasyAntInstallation[0]);
            this.save();
            return true;
        }

        public EasyAnt newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (EasyAnt)((Object)req.bindJSON(this.clazz, formData));
        }

        public FormValidation doCheckEasyAntHome(@QueryParameter String value) {
            File f = new File(Util.fixNull((String)value));
            if (!f.isDirectory()) {
                return FormValidation.error((String)(f + " is not a directory"));
            }
            if (!new File(f, "bin").exists() && !new File(f, "lib").exists()) {
                return FormValidation.error((String)(f + " doesn't look like an EasyAnt directory"));
            }
            if (!new File(f, "bin/easyant").exists()) {
                return FormValidation.error((String)(f + " doesn't look like an EasyAnt directory"));
            }
            return FormValidation.ok();
        }
    }
}

