/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.ReservationDescription;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2ComputerLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.PrintStream;
import org.jets3t.service.S3ServiceException;

public abstract class EC2ComputerLauncher
extends ComputerLauncher {
    public void launch(SlaveComputer _computer, StreamTaskListener listener) {
        try {
            EC2Computer computer = (EC2Computer)_computer;
            PrintStream logger = listener.getLogger();
            boolean reportedWaiting = false;
            block9: while (true) {
                switch (1.$SwitchMap$hudson$plugins$ec2$InstanceState[computer.getState().ordinal()]) {
                    case 1: 
                    case 2: {
                        String console = computer.getConsoleOutput();
                        if (console != null && console.length() != 0) break block9;
                        if (!reportedWaiting) {
                            reportedWaiting = true;
                            logger.println("Waiting for the EC2 instance to boot up");
                        }
                        Thread.sleep(5000L);
                        continue block9;
                    }
                    case 3: 
                    case 4: {
                        logger.println("The instance " + computer.getInstanceId() + " appears to be shut down. Aborting launch.");
                        return;
                    }
                    default: {
                        continue block9;
                    }
                }
                break;
            }
            this.launch(computer, logger, computer.describeInstance());
        }
        catch (EC2Exception e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (S3ServiceException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
    }

    protected abstract void launch(EC2Computer var1, PrintStream var2, ReservationDescription.Instance var3) throws EC2Exception, IOException, InterruptedException, S3ServiceException;
}

