/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.DigestInputStream;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;

/*
 * Exception performing whole class analysis ignored.
 */
final class EC2PrivateKey {
    private final Secret privateKey;

    EC2PrivateKey(String privateKey) {
        this.privateKey = Secret.fromString((String)privateKey.trim());
    }

    public String getFingerprint() throws IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        BufferedReader r = new BufferedReader(new StringReader(this.privateKey.toString()));
        PEMReader pem = new PEMReader((Reader)r);
        KeyPair pair = (KeyPair)pem.readObject();
        if (pair == null) {
            return null;
        }
        PrivateKey key = pair.getPrivate();
        return EC2PrivateKey.digest((PrivateKey)key);
    }

    public boolean isPrivateKey() throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new StringReader(this.privateKey.toString()));
        while ((line = br.readLine()) != null) {
            if (!line.equals("-----BEGIN RSA PRIVATE KEY-----")) continue;
            return true;
        }
        return false;
    }

    public KeyPairInfo find(Jec2 ec2) throws IOException, EC2Exception {
        String fp = this.getFingerprint();
        for (KeyPairInfo kp : ec2.describeKeyPairs(new String[0])) {
            if (!kp.getKeyFingerprint().equals(fp)) continue;
            return new KeyPairInfo(kp.getKeyName(), fp, this.privateKey.toString());
        }
        return null;
    }

    public String toString() {
        return this.privateKey.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String digest(PrivateKey k) throws IOException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("SHA1");
            DigestInputStream in = new DigestInputStream(new ByteArrayInputStream(k.getEncoded()), md5);
            try {
                while (in.read(new byte[128]) > 0) {
                }
            }
            finally {
                in.close();
            }
            StringBuilder buf = new StringBuilder();
            char[] hex = Hex.encodeHex((byte[])md5.digest());
            for (int i = 0; i < hex.length; i += 2) {
                if (buf.length() > 0) {
                    buf.append(':');
                }
                buf.append(hex, i, 2);
            }
            return buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

