/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2ComputerLauncher;
import hudson.plugins.ec2.ssh.EC2UnixLauncher;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.jets3t.service.S3ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2UnixLauncher
extends EC2ComputerLauncher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launch(EC2Computer computer, PrintStream logger, ReservationDescription.Instance inst) throws IOException, EC2Exception, InterruptedException, S3ServiceException {
        logger.println("Connecting to " + inst.getDnsName());
        Connection conn = new Connection(inst.getDnsName());
        boolean successful = false;
        try {
            Session sess;
            conn.connect((ServerHostKeyVerifier)new /* Unavailable Anonymous Inner Class!! */);
            KeyPairInfo key = EC2Cloud.get().getKeyPair();
            boolean isAuthenticated = conn.authenticateWithPublicKey("root", key.getKeyMaterial().toCharArray(), "");
            if (!isAuthenticated) {
                logger.println("Authentication failed");
                return;
            }
            SCPClient scp = conn.createSCPClient();
            String initScript = computer.getNode().initScript;
            if (initScript != null && initScript.trim().length() > 0) {
                logger.println("Executing init script");
                scp.put(initScript.getBytes("UTF-8"), "init.sh", "/tmp", "0700");
                sess = conn.openSession();
                sess.requestDumbPTY();
                sess.execCommand("/tmp/init.sh");
                sess.getStdin().close();
                sess.getStderr().close();
                IOUtils.copy((InputStream)sess.getStdout(), (OutputStream)logger);
                int exitStatus = sess.getExitStatus();
                sess.close();
                if (exitStatus != 0) {
                    logger.println("init script failed: exit code=" + exitStatus);
                    return;
                }
            }
            logger.println("Verifying that java exists");
            if (this.exec(conn, "java -fullversion", (OutputStream)logger) != 0) {
                logger.println("Installing Java");
                String jdk = "java1.6.0_12";
                String path = "/hudson-ci/jdk/linux-i586/" + jdk + ".tgz";
                URL url = EC2Cloud.get().buildPresignedURL(path);
                if (this.exec(conn, "wget -nv -O /usr/" + jdk + ".tgz '" + url + "'", (OutputStream)logger) != 0) {
                    logger.println("Failed to download Java");
                    return;
                }
                if (this.exec(conn, "tar xz -C /usr -f /usr/" + jdk + ".tgz", (OutputStream)logger) != 0) {
                    logger.println("Failed to install Java");
                    return;
                }
                if (this.exec(conn, "ln -s /usr/" + jdk + "/bin/java /bin/java", (OutputStream)logger) != 0) {
                    logger.println("Failed to symlink Java");
                    return;
                }
            }
            logger.println("Copying slave.jar");
            scp.put(Hudson.getInstance().getJnlpJars("slave.jar").readFully(), "slave.jar", "/tmp");
            logger.println("Launching slave agent");
            sess = conn.openSession();
            sess.execCommand("java -jar /tmp/slave.jar");
            computer.setChannel(sess.getStdout(), sess.getStdin(), (OutputStream)logger, (Channel.Listener)new /* Unavailable Anonymous Inner Class!! */);
            successful = true;
        }
        finally {
            if (!successful) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec(Connection ssh, String command, OutputStream output) throws IOException, InterruptedException {
        Session session = ssh.openSession();
        try {
            session.execCommand(command);
            PumpThread t1 = new PumpThread(session.getStdout(), output);
            t1.start();
            PumpThread t2 = new PumpThread(session.getStderr(), output);
            t2.start();
            session.getStdin().close();
            t1.join();
            t2.join();
            for (int i = 0; i < 10; ++i) {
                Integer r = session.getExitStatus();
                if (r != null) {
                    int n = r;
                    return n;
                }
                Thread.sleep(100L);
            }
            int n = -1;
            return n;
        }
        finally {
            session.close();
        }
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

