/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.model.Descriptor;
import hudson.plugins.ec2.EC2Computer;
import hudson.slaves.RetentionStrategy;
import hudson.util.TimeUnit2;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2RetentionStrategy
extends RetentionStrategy<EC2Computer> {
    private static final Logger LOGGER = Logger.getLogger(EC2RetentionStrategy.class.getName());

    @DataBoundConstructor
    public EC2RetentionStrategy() {
    }

    public synchronized long check(EC2Computer c) {
        long idleMilliseconds;
        if (c.isIdle() && (idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds()) > TimeUnit2.MINUTES.toMillis(30L)) {
            LOGGER.info("Disconnecting " + c.getName());
            c.getNode().terminate();
        }
        return 1L;
    }

    public void start(EC2Computer c) {
        c.connect(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "EC2";
        }
    }
}

