/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Slave;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveTemplate
implements Describable<SlaveTemplate> {
    public final String ami;
    public final String description;
    public final String remoteFS;
    public final InstanceType type;
    public final String labels;
    public final String initScript;
    protected transient EC2Cloud parent;

    @DataBoundConstructor
    public SlaveTemplate(String ami, String remoteFS, InstanceType type, String labels, String description, String initScript) {
        this.ami = ami;
        this.remoteFS = remoteFS;
        this.type = type;
        this.labels = Util.fixNull((String)labels);
        this.description = description;
        this.initScript = initScript;
    }

    public EC2Cloud getParent() {
        return this.parent;
    }

    public String getDisplayName() {
        return this.description + " (" + this.ami + ")";
    }

    public int getNumExecutors() {
        return EC2Slave.toNumExecutors(this.type);
    }

    public boolean containsLabel(Label l) {
        if (l == null) {
            return true;
        }
        for (String t : this.labels.split("\\s+")) {
            if (!t.equals(l.getName())) continue;
            return true;
        }
        return false;
    }

    public EC2Slave provision(TaskListener listener) throws EC2Exception, IOException {
        PrintStream logger = listener.getLogger();
        Jec2 ec2 = this.getParent().connect();
        try {
            logger.println("Launching " + this.ami);
            KeyPairInfo keyPair = this.parent.getPrivateKey().find(ec2);
            if (keyPair == null) {
                throw new EC2Exception("No matching keypair found on EC2. Is the EC2 private key a valid one?");
            }
            ReservationDescription.Instance inst = (ReservationDescription.Instance)ec2.runInstances(this.ami, 1, 1, Collections.emptyList(), null, keyPair.getKeyName(), this.type).getInstances().get(0);
            return new EC2Slave(inst.getInstanceId(), this.description, this.remoteFS, this.type, this.labels, this.initScript);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
    }

    public EC2Slave attach(String instanceId, TaskListener listener) throws EC2Exception, IOException {
        PrintStream logger = listener.getLogger();
        Jec2 ec2 = this.getParent().connect();
        try {
            logger.println("Attaching to " + instanceId);
            ReservationDescription.Instance inst = (ReservationDescription.Instance)((ReservationDescription)ec2.describeInstances(Collections.singletonList(instanceId)).get(0)).getInstances().get(0);
            return new EC2Slave(inst.getInstanceId(), this.description, this.remoteFS, this.type, this.labels, this.initScript);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
    }

    public Descriptor<SlaveTemplate> getDescriptor() {
        return Hudson.getInstance().getDescriptor(this.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<SlaveTemplate> {
        public String getDisplayName() {
            return null;
        }

        public void doCheckAmi(final @QueryParameter String value) throws IOException, ServletException {
            new FormFieldValidator(null){

                protected void check() throws IOException, ServletException {
                    EC2Cloud cloud = EC2Cloud.get();
                    if (cloud != null) {
                        try {
                            List img = cloud.connect().describeImages(new String[]{value});
                            this.ok(((ImageDescription)img.get(0)).getImageLocation() + " by " + ((ImageDescription)img.get(0)).getImageOwnerId());
                        }
                        catch (EC2Exception e) {
                            this.error(e.getMessage());
                        }
                    } else {
                        this.ok();
                    }
                }
            }.process();
        }
    }
}

