/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.plugins.ec2.AwsRegion;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.SlaveTemplate;
import java.net.URL;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonEC2Cloud
extends EC2Cloud {
    private AwsRegion region;

    @DataBoundConstructor
    public AmazonEC2Cloud(AwsRegion region, String accessId, String secretKey, String privateKey, String instanceCapStr, List<SlaveTemplate> templates) {
        super("ec2-" + region.name(), accessId, secretKey, privateKey, instanceCapStr, templates);
        this.region = region;
    }

    public AwsRegion getRegion() {
        if (this.region == null) {
            this.region = AwsRegion.US_EAST_1;
        }
        return this.region;
    }

    public URL getEc2EndpointUrl() {
        return this.getRegion().ec2Endpoint;
    }

    public URL getS3EndpointUrl() {
        return this.getRegion().s3Endpoint;
    }
}

