/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.Eucalyptus;
import hudson.plugins.ec2.SlaveTemplate;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.jets3t.service.Jets3tProperties;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Eucalyptus
extends EC2Cloud {
    private transient Metadata metadata;
    public final URL url;

    @DataBoundConstructor
    public Eucalyptus(URL url, String accessId, String secretKey, String privateKey, String instanceCapStr, List<SlaveTemplate> templates) throws IOException {
        super("eucalyptus", accessId, secretKey, privateKey, instanceCapStr, templates);
        this.url = url;
    }

    private Metadata getMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = new Metadata(this.url);
        }
        return this.metadata;
    }

    public URL getEc2EndpointUrl() throws IOException {
        return this.getMetadata().ec2endpoint;
    }

    public URL getS3EndpointUrl() throws IOException {
        return this.getMetadata().s3endpoint;
    }

    protected Jets3tProperties buildJets3tProperties(URL s3) {
        Jets3tProperties props = super.buildJets3tProperties(s3);
        props.setProperty("s3service.disable-dns-buckets", "true");
        return props;
    }
}

