/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Slave;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveTemplate
implements Describable<SlaveTemplate> {
    public final String ami;
    public final String description;
    public final String remoteFS;
    public final InstanceType type;
    public final String labels;
    public final String initScript;
    public final String userData;
    public final String numExecutors;
    public final String remoteAdmin;
    public final String rootCommandPrefix;
    public final String jvmopts;
    protected transient EC2Cloud parent;
    private transient Set<Label> labelSet;

    @DataBoundConstructor
    public SlaveTemplate(String ami, String remoteFS, InstanceType type, String labelString, String description, String initScript, String userData, String numExecutors, String remoteAdmin, String rootCommandPrefix, String jvmopts) {
        this.ami = ami;
        this.remoteFS = remoteFS;
        this.type = type;
        this.labels = Util.fixNull((String)labelString);
        this.description = description;
        this.initScript = initScript;
        this.userData = userData;
        this.numExecutors = Util.fixNull((String)numExecutors).trim();
        this.remoteAdmin = remoteAdmin;
        this.rootCommandPrefix = rootCommandPrefix;
        this.jvmopts = jvmopts;
        this.readResolve();
    }

    public EC2Cloud getParent() {
        return this.parent;
    }

    public String getLabelString() {
        return this.labels;
    }

    public String getDisplayName() {
        return this.description + " (" + this.ami + ")";
    }

    public int getNumExecutors() {
        try {
            return Integer.parseInt(this.numExecutors);
        }
        catch (NumberFormatException e) {
            return EC2Slave.toNumExecutors(this.type);
        }
    }

    public String getRemoteAdmin() {
        return this.remoteAdmin;
    }

    public String getRootCommandPrefix() {
        return this.rootCommandPrefix;
    }

    public boolean containsLabel(Label l) {
        return l == null || this.labelSet.contains(l);
    }

    public EC2Slave provision(TaskListener listener) throws EC2Exception, IOException {
        PrintStream logger = listener.getLogger();
        Jec2 ec2 = this.getParent().connect();
        try {
            logger.println("Launching " + this.ami);
            KeyPairInfo keyPair = this.parent.getPrivateKey().find(ec2);
            if (keyPair == null) {
                throw new EC2Exception("No matching keypair found on EC2. Is the EC2 private key a valid one?");
            }
            ReservationDescription.Instance inst = (ReservationDescription.Instance)ec2.runInstances(this.ami, 1, 1, Collections.emptyList(), this.userData, keyPair.getKeyName(), this.type).getInstances().get(0);
            return this.newSlave(inst);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
    }

    private EC2Slave newSlave(ReservationDescription.Instance inst) throws Descriptor.FormException, IOException {
        return new EC2Slave(inst.getInstanceId(), this.description, this.remoteFS, this.getNumExecutors(), this.labels, this.initScript, this.remoteAdmin, this.rootCommandPrefix, this.jvmopts);
    }

    public EC2Slave attach(String instanceId, TaskListener listener) throws EC2Exception, IOException {
        PrintStream logger = listener.getLogger();
        Jec2 ec2 = this.getParent().connect();
        try {
            logger.println("Attaching to " + instanceId);
            ReservationDescription.Instance inst = (ReservationDescription.Instance)((ReservationDescription)ec2.describeInstances(Collections.singletonList(instanceId)).get(0)).getInstances().get(0);
            return this.newSlave(inst);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
    }

    protected Object readResolve() {
        this.labelSet = Label.parse((String)this.labels);
        return this;
    }

    public Descriptor<SlaveTemplate> getDescriptor() {
        return Hudson.getInstance().getDescriptor(this.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SlaveTemplate> {
        public String getDisplayName() {
            return null;
        }

        public String getHelpFile(String fieldName) {
            String p = super.getHelpFile(fieldName);
            if (p == null) {
                p = Hudson.getInstance().getDescriptor(EC2Slave.class).getHelpFile(fieldName);
            }
            return p;
        }

        public FormValidation doValidateAmi(@QueryParameter String accessId, @QueryParameter String secretKey, @QueryParameter String ec2EndpointUrl, @QueryParameter String ami) throws IOException, ServletException {
            Jec2 jec2 = EC2Cloud.connect(accessId, secretKey, EC2Cloud.checkEndPoint(ec2EndpointUrl));
            if (jec2 != null) {
                try {
                    LinkedList<String> images = new LinkedList<String>();
                    images.add(ami);
                    LinkedList owners = new LinkedList();
                    LinkedList<String> users = new LinkedList<String>();
                    users.add("self");
                    List img = jec2.describeImages(images, owners, users, null);
                    if (img == null || img.isEmpty()) {
                        return FormValidation.error((String)("No such AMI, or not usable with this accessId: " + ami));
                    }
                    return FormValidation.ok((String)(((ImageDescription)img.get(0)).getImageLocation() + " by " + ((ImageDescription)img.get(0)).getImageOwnerId()));
                }
                catch (EC2Exception e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

