// CHECKSTYLE:OFF

package hudson.plugins.ec2;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Success
     * 
     */
    public static String EC2Cloud_Success() {
        return holder.format("EC2Cloud.Success");
    }

    /**
     * Success
     * 
     */
    public static Localizable _EC2Cloud_Success() {
        return new Localizable(holder, "EC2Cloud.Success");
    }

    /**
     * Invalid AWS access key ID
     * 
     */
    public static String EC2Cloud_InvalidAccessId() {
        return holder.format("EC2Cloud.InvalidAccessId");
    }

    /**
     * Invalid AWS access key ID
     * 
     */
    public static Localizable _EC2Cloud_InvalidAccessId() {
        return new Localizable(holder, "EC2Cloud.InvalidAccessId");
    }

    /**
     * Invalid AWS secret access key
     * 
     */
    public static String EC2Cloud_InvalidSecretKey() {
        return holder.format("EC2Cloud.InvalidSecretKey");
    }

    /**
     * Invalid AWS secret access key
     * 
     */
    public static Localizable _EC2Cloud_InvalidSecretKey() {
        return new Localizable(holder, "EC2Cloud.InvalidSecretKey");
    }

}
