/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.SlaveTemplate;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AmazonEC2Cloud
extends EC2Cloud {
    private String region;
    public static boolean testMode;

    @DataBoundConstructor
    public AmazonEC2Cloud(String accessId, String secretKey, String region, String privateKey, String instanceCapStr, List<SlaveTemplate> templates) {
        super("ec2-" + region, accessId, secretKey, privateKey, instanceCapStr, templates);
        this.region = region;
    }

    public String getRegion() {
        if (this.region == null) {
            this.region = "us-east-1";
        }
        if (this.region.indexOf(95) > 0) {
            return this.region.replace('_', '-').toLowerCase(Locale.ENGLISH);
        }
        return this.region;
    }

    public static URL getEc2EndpointUrl(String region) {
        try {
            return new URL("https://" + region + "." + "ec2.amazonaws.com" + "/");
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    public URL getEc2EndpointUrl() {
        return AmazonEC2Cloud.getEc2EndpointUrl((String)this.getRegion());
    }

    public URL getS3EndpointUrl() {
        try {
            return new URL("https://" + this.getRegion() + ".s3.amazonaws.com/");
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }
}

