/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.plugins.ec2.EC2Computer;
import hudson.slaves.RetentionStrategy;
import hudson.util.TimeUnit2;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2RetentionStrategy
extends RetentionStrategy<EC2Computer> {
    public final int idleTerminationMinutes;
    private static final Logger LOGGER = Logger.getLogger(EC2RetentionStrategy.class.getName());
    public static boolean disabled = Boolean.getBoolean(EC2RetentionStrategy.class.getName() + ".disabled");

    @DataBoundConstructor
    public EC2RetentionStrategy(String idleTerminationMinutes) {
        if (idleTerminationMinutes == null || idleTerminationMinutes.trim() == "") {
            this.idleTerminationMinutes = 0;
        } else {
            int value = 30;
            try {
                value = Integer.parseInt(idleTerminationMinutes);
            }
            catch (NumberFormatException nfe) {
                LOGGER.info("Malformed default idleTermination value: " + idleTerminationMinutes);
            }
            this.idleTerminationMinutes = value;
        }
    }

    public synchronized long check(EC2Computer c) {
        long idleMilliseconds;
        if (this.idleTerminationMinutes == 0) {
            return 1L;
        }
        if (c.isIdle() && !disabled && (idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds()) > TimeUnit2.MINUTES.toMillis((long)this.idleTerminationMinutes)) {
            LOGGER.info("Disconnecting " + c.getName());
            c.getNode().terminate();
        }
        return 1L;
    }

    public void start(EC2Computer c) {
        c.connect(false);
    }
}

