/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.services.ec2.model.Tag;
import hudson.model.AbstractDescribableImpl;
import java.util.LinkedList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2Tag
extends AbstractDescribableImpl<EC2Tag> {
    private String name;
    private String value;

    @DataBoundConstructor
    public EC2Tag(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public EC2Tag(Tag t) {
        this.name = t.getKey();
        this.value = t.getValue();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "EC2Tag: " + this.name + "->" + this.value;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof EC2Tag)) {
            return false;
        }
        EC2Tag other = (EC2Tag)o;
        if (this.name == null && other.name != null || !this.name.equals(other.name)) {
            return false;
        }
        return (this.value != null || other.value == null) && this.value.equals(other.value);
    }

    public static List<EC2Tag> fromAmazonTags(List<Tag> amazon_tags) {
        if (null == amazon_tags) {
            return null;
        }
        LinkedList<EC2Tag> result = new LinkedList<EC2Tag>();
        for (Tag t : amazon_tags) {
            result.add(new EC2Tag(t));
        }
        return result;
    }
}

