/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.Tag;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Slave;
import hudson.plugins.ec2.EC2Tag;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveTemplate
implements Describable<SlaveTemplate> {
    public final String ami;
    public final String description;
    public final String zone;
    public final String securityGroups;
    public final String remoteFS;
    public final String sshPort;
    public final InstanceType type;
    public final String labels;
    public final String initScript;
    public final String userData;
    public final String numExecutors;
    public final String remoteAdmin;
    public final String rootCommandPrefix;
    public final String jvmopts;
    public final String subnetId;
    public final String idleTerminationMinutes;
    public final boolean stopOnTerminate;
    private final List<EC2Tag> tags;
    public final boolean usePrivateDnsName;
    protected transient EC2Cloud parent;
    private transient Set<LabelAtom> labelSet;
    private transient Set<String> securityGroupSet;

    @DataBoundConstructor
    public SlaveTemplate(String ami, String zone, String securityGroups, String remoteFS, String sshPort, InstanceType type, String labelString, String description, String initScript, String userData, String numExecutors, String remoteAdmin, String rootCommandPrefix, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName) {
        this.ami = ami;
        this.zone = zone;
        this.securityGroups = securityGroups;
        this.remoteFS = remoteFS;
        this.sshPort = sshPort;
        this.type = type;
        this.labels = Util.fixNull((String)labelString);
        this.description = description;
        this.initScript = initScript;
        this.userData = userData;
        this.numExecutors = Util.fixNull((String)numExecutors).trim();
        this.remoteAdmin = remoteAdmin;
        this.rootCommandPrefix = rootCommandPrefix;
        this.jvmopts = jvmopts;
        this.stopOnTerminate = stopOnTerminate;
        this.subnetId = subnetId;
        this.tags = tags;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.usePrivateDnsName = usePrivateDnsName;
        this.readResolve();
    }

    public EC2Cloud getParent() {
        return this.parent;
    }

    public String getLabelString() {
        return this.labels;
    }

    public String getDisplayName() {
        return this.description + " (" + this.ami + ")";
    }

    String getZone() {
        return this.zone;
    }

    public String getSecurityGroupString() {
        return this.securityGroups;
    }

    public Set<String> getSecurityGroupSet() {
        return this.securityGroupSet;
    }

    public Set<String> parseSecurityGroups() {
        if (this.securityGroups == null || "".equals(this.securityGroups.trim())) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(this.securityGroups.split("\\s*,\\s*")));
    }

    public int getNumExecutors() {
        try {
            return Integer.parseInt(this.numExecutors);
        }
        catch (NumberFormatException e) {
            return EC2Slave.toNumExecutors((InstanceType)this.type);
        }
    }

    public int getSshPort() {
        try {
            return Integer.parseInt(this.sshPort);
        }
        catch (NumberFormatException e) {
            return 22;
        }
    }

    public String getRemoteAdmin() {
        return this.remoteAdmin;
    }

    public String getRootCommandPrefix() {
        return this.rootCommandPrefix;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public List<EC2Tag> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public String getidleTerminationMinutes() {
        return this.idleTerminationMinutes;
    }

    public Set getLabelSet() {
        return this.labelSet;
    }

    public boolean containsLabel(Label l) {
        return l == null || this.labelSet.contains(l);
    }

    public EC2Slave provision(TaskListener listener) throws AmazonClientException, IOException {
        PrintStream logger = listener.getLogger();
        AmazonEC2 ec2 = this.getParent().connect();
        try {
            logger.println("Launching " + this.ami);
            KeyPair keyPair = this.parent.getPrivateKey().find(ec2);
            if (keyPair == null) {
                throw new AmazonClientException("No matching keypair found on EC2. Is the EC2 private key a valid one?");
            }
            RunInstancesRequest request = new RunInstancesRequest(this.ami, Integer.valueOf(1), Integer.valueOf(1));
            if (StringUtils.isNotBlank((String)this.getZone())) {
                Placement placement = new Placement(this.getZone());
                request.setPlacement(placement);
            }
            if (StringUtils.isNotBlank((String)this.getSubnetId())) {
                request.setSubnetId(this.getSubnetId());
                if (!this.securityGroupSet.isEmpty()) {
                    ArrayList<String> group_ids = new ArrayList<String>();
                    DescribeSecurityGroupsRequest group_req = new DescribeSecurityGroupsRequest();
                    group_req.withFilters(new Filter[]{new Filter("group-name").withValues((Collection)this.securityGroupSet)});
                    DescribeSecurityGroupsResult group_result = ec2.describeSecurityGroups(group_req);
                    for (SecurityGroup group : group_result.getSecurityGroups()) {
                        if (group.getVpcId() == null || group.getVpcId().isEmpty()) continue;
                        ArrayList<Filter> filters = new ArrayList<Filter>();
                        filters.add(new Filter("vpc-id").withValues(new String[]{group.getVpcId()}));
                        filters.add(new Filter("state").withValues(new String[]{"available"}));
                        filters.add(new Filter("subnet-id").withValues(new String[]{this.getSubnetId()}));
                        DescribeSubnetsRequest subnet_req = new DescribeSubnetsRequest();
                        subnet_req.withFilters(filters);
                        DescribeSubnetsResult subnet_result = ec2.describeSubnets(subnet_req);
                        List subnets = subnet_result.getSubnets();
                        if (subnets == null || subnets.isEmpty()) continue;
                        group_ids.add(group.getGroupId());
                    }
                    if (this.securityGroupSet.size() != group_ids.size()) {
                        throw new AmazonClientException("Security groups must all be VPC security groups to work in a VPC context");
                    }
                    if (!group_ids.isEmpty()) {
                        request.setSecurityGroupIds(group_ids);
                    }
                }
            } else {
                request.setSecurityGroups((Collection)this.securityGroupSet);
            }
            request.setUserData(Base64.encodeBase64String((byte[])this.userData.getBytes()));
            request.setKeyName(keyPair.getKeyName());
            request.setInstanceType(this.type.toString());
            Instance inst = (Instance)ec2.runInstances(request).getReservation().getInstances().get(0);
            if (!this.tags.isEmpty()) {
                HashSet<Tag> inst_tags = new HashSet<Tag>();
                for (EC2Tag t : this.tags) {
                    inst_tags.add(new Tag(t.getName(), t.getValue()));
                }
                CreateTagsRequest tag_request = new CreateTagsRequest();
                tag_request.withResources(new String[]{inst.getInstanceId()}).setTags(inst_tags);
                ec2.createTags(tag_request);
                inst.setTags(inst_tags);
            }
            return this.newSlave(inst);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
    }

    private EC2Slave newSlave(Instance inst) throws Descriptor.FormException, IOException {
        return new EC2Slave(inst.getInstanceId(), this.description, this.remoteFS, this.getSshPort(), this.getNumExecutors(), this.labels, this.initScript, this.remoteAdmin, this.rootCommandPrefix, this.jvmopts, this.stopOnTerminate, this.idleTerminationMinutes, inst.getPublicDnsName(), inst.getPrivateDnsName(), EC2Tag.fromAmazonTags((List)inst.getTags()), this.usePrivateDnsName);
    }

    public EC2Slave attach(String instanceId, TaskListener listener) throws AmazonClientException, IOException {
        PrintStream logger = listener.getLogger();
        AmazonEC2 ec2 = this.getParent().connect();
        try {
            logger.println("Attaching to " + instanceId);
            DescribeInstancesRequest request = new DescribeInstancesRequest();
            request.setInstanceIds(Collections.singletonList(instanceId));
            Instance inst = (Instance)((Reservation)ec2.describeInstances(request).getReservations().get(0)).getInstances().get(0);
            return this.newSlave(inst);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
    }

    protected Object readResolve() {
        this.labelSet = Label.parse((String)this.labels);
        this.securityGroupSet = this.parseSecurityGroups();
        return this;
    }

    public Descriptor<SlaveTemplate> getDescriptor() {
        return Hudson.getInstance().getDescriptor(this.getClass());
    }
}

