/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.KeyPair;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2ComputerLauncher;
import hudson.plugins.ec2.ssh.EC2UnixLauncher;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2UnixLauncher
extends EC2ComputerLauncher {
    private final int FAILED = -1;
    private final int SAMEUSER = 0;
    private final int RECONNECT = -2;

    protected String buildUpCommand(EC2Computer computer, String command) {
        if (!computer.getRemoteAdmin().equals("root")) {
            command = computer.getRootCommandPrefix() + " " + command;
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launch(EC2Computer computer, PrintStream logger, Instance inst) throws IOException, AmazonClientException, InterruptedException {
        Connection cleanupConn = null;
        boolean successful = false;
        try {
            Connection bootstrapConn = this.connectToSsh(computer, logger);
            int bootstrapResult = this.bootstrap(bootstrapConn, computer, logger);
            if (bootstrapResult == -1) {
                return;
            }
            if (bootstrapResult == 0) {
                cleanupConn = bootstrapConn;
            } else {
                cleanupConn = this.connectToSsh(computer, logger);
                KeyPair key = EC2Cloud.get().getKeyPair();
                if (!cleanupConn.authenticateWithPublicKey(computer.getRemoteAdmin(), key.getKeyMaterial().toCharArray(), "")) {
                    logger.println("Authentication failed");
                    return;
                }
            }
            Connection conn = cleanupConn;
            SCPClient scp = conn.createSCPClient();
            String initScript = computer.getNode().initScript;
            if (initScript != null && initScript.trim().length() > 0 && this.exec(conn, "test -e ~/.hudson-run-init", (OutputStream)logger) != 0) {
                logger.println("Executing init script");
                scp.put(initScript.getBytes("UTF-8"), "init.sh", "/tmp", "0700");
                Session sess = conn.openSession();
                sess.requestDumbPTY();
                sess.execCommand(this.buildUpCommand(computer, "/tmp/init.sh"));
                sess.getStdin().close();
                sess.getStderr().close();
                IOUtils.copy((InputStream)sess.getStdout(), (OutputStream)logger);
                int exitStatus = this.waitCompletion(sess);
                if (exitStatus != 0) {
                    logger.println("init script failed: exit code=" + exitStatus);
                    return;
                }
                sess = conn.openSession();
                sess.requestDumbPTY();
                sess.execCommand(this.buildUpCommand(computer, "touch ~/.hudson-run-init"));
            }
            logger.println("Verifying that java exists");
            if (this.exec(conn, "java -fullversion", (OutputStream)logger) != 0) {
                logger.println("Installing Java");
                String jdk = "java1.6.0_12";
                String path = "/hudson-ci/jdk/linux-i586/" + jdk + ".tgz";
                URL url = EC2Cloud.get().buildPresignedURL(path);
                if (this.exec(conn, "wget -nv -O /tmp/" + jdk + ".tgz '" + url + "'", (OutputStream)logger) != 0) {
                    logger.println("Failed to download Java");
                    return;
                }
                if (this.exec(conn, this.buildUpCommand(computer, "tar xz -C /usr -f /tmp/" + jdk + ".tgz"), (OutputStream)logger) != 0) {
                    logger.println("Failed to install Java");
                    return;
                }
                if (this.exec(conn, this.buildUpCommand(computer, "ln -s /usr/" + jdk + "/bin/java /bin/java"), (OutputStream)logger) != 0) {
                    logger.println("Failed to symlink Java");
                    return;
                }
            }
            logger.println("Copying slave.jar");
            scp.put(Hudson.getInstance().getJnlpJars("slave.jar").readFully(), "slave.jar", "/tmp");
            String jvmopts = computer.getNode().jvmopts;
            String launchString = "java " + (jvmopts != null ? jvmopts : "") + " -jar /tmp/slave.jar";
            logger.println("Launching slave agent: " + launchString);
            Session sess = conn.openSession();
            sess.execCommand(launchString);
            computer.setChannel(sess.getStdout(), sess.getStdin(), (OutputStream)logger, (Channel.Listener)new /* Unavailable Anonymous Inner Class!! */);
            successful = true;
        }
        finally {
            if (cleanupConn != null && !successful) {
                cleanupConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int bootstrap(Connection bootstrapConn, EC2Computer computer, PrintStream logger) throws IOException, InterruptedException, AmazonClientException {
        boolean closeBootstrap = true;
        try {
            int tries = 20;
            boolean isAuthenticated = false;
            KeyPair key = EC2Cloud.get().getKeyPair();
            while (tries-- > 0) {
                logger.println("Authenticating as " + computer.getRemoteAdmin());
                isAuthenticated = bootstrapConn.authenticateWithPublicKey(computer.getRemoteAdmin(), key.getKeyMaterial().toCharArray(), "");
                if (isAuthenticated) break;
                logger.println("Authentication failed. Trying again...");
                Thread.sleep(10000L);
            }
            if (!isAuthenticated) {
                logger.println("Authentication failed");
                int n = -1;
                return n;
            }
            closeBootstrap = false;
            int n = 0;
            return n;
        }
        finally {
            if (closeBootstrap) {
                bootstrapConn.close();
            }
        }
    }

    private Connection connectToSsh(EC2Computer computer, PrintStream logger) throws AmazonClientException, InterruptedException {
        while (true) {
            try {
                Instance instance = computer.updateInstanceDescription();
                String vpc_id = instance.getVpcId();
                String host = computer.getNode().usePrivateDnsName ? instance.getPrivateDnsName() : (vpc_id == null || vpc_id.equals("") ? instance.getPublicDnsName() : instance.getPrivateIpAddress());
                if ("0.0.0.0".equals(host)) {
                    logger.println("Invalid host 0.0.0.0, your host is most likely waiting for an ip address.");
                    throw new IOException("goto sleep");
                }
                int port = computer.getSshPort();
                logger.println("Connecting to " + host + " on port " + port + ". ");
                Connection conn = new Connection(host, port);
                logger.println("Connected to server. Now connecting via ssh.");
                conn.connect((ServerHostKeyVerifier)new /* Unavailable Anonymous Inner Class!! */);
                logger.println("Connected via SSH.");
                return conn;
            }
            catch (IOException e) {
                logger.println("Waiting for SSH to come up. Sleeping 5.");
                Thread.sleep(5000L);
                continue;
            }
            break;
        }
    }

    private int waitCompletion(Session session) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            Integer r = session.getExitStatus();
            if (r != null) {
                return r;
            }
            Thread.sleep(100L);
        }
        return -1;
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exec(Connection conn, String command, OutputStream output) throws IOException, InterruptedException {
        Session session = conn.openSession();
        try {
            session.execCommand(command);
            PumpThread t1 = new PumpThread(session.getStdout(), output);
            t1.start();
            PumpThread t2 = new PumpThread(session.getStderr(), output);
            t2.start();
            session.getStdin().close();
            t1.join();
            t2.join();
            session.waitForCondition(32, 3000L);
            Integer r = session.getExitStatus();
            if (r != null) {
                int n = r;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            session.close();
        }
    }
}

