/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeRegionsResult;
import com.amazonaws.services.ec2.model.Region;
import hudson.Extension;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonEC2Cloud
extends EC2Cloud {
    private String region;
    public static boolean testMode;

    @DataBoundConstructor
    public AmazonEC2Cloud(String accessId, String secretKey, String region, String privateKey, String instanceCapStr, List<SlaveTemplate> templates) {
        super("ec2-" + region, accessId, secretKey, privateKey, instanceCapStr, templates);
        this.region = region;
    }

    public String getRegion() {
        if (this.region == null) {
            this.region = "us-east-1";
        }
        if (this.region.indexOf(95) > 0) {
            return this.region.replace('_', '-').toLowerCase(Locale.ENGLISH);
        }
        return this.region;
    }

    public static URL getEc2EndpointUrl(String region) {
        try {
            return new URL("https://" + region + "." + "ec2.amazonaws.com" + "/");
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    @Override
    public URL getEc2EndpointUrl() {
        return AmazonEC2Cloud.getEc2EndpointUrl(this.getRegion());
    }

    @Override
    public URL getS3EndpointUrl() {
        try {
            return new URL("https://" + this.getRegion() + ".s3.amazonaws.com/");
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends EC2Cloud.DescriptorImpl {
        public String getDisplayName() {
            return "Amazon EC2";
        }

        public ListBoxModel doFillRegionItems(@QueryParameter String accessId, @QueryParameter String secretKey) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            if (testMode) {
                model.add("us-east-1");
                return model;
            }
            if (!StringUtils.isEmpty((String)accessId) && !StringUtils.isEmpty((String)secretKey)) {
                AmazonEC2 client = EC2Cloud.connect(accessId, secretKey, new URL("http://ec2.amazonaws.com"));
                DescribeRegionsResult regions = client.describeRegions();
                List regionList = regions.getRegions();
                for (Region r : regionList) {
                    model.add(r.getRegionName(), r.getRegionName());
                }
            }
            return model;
        }

        public FormValidation doTestConnection(@QueryParameter String region, @QueryParameter String accessId, @QueryParameter String secretKey, @QueryParameter String privateKey) throws IOException, ServletException {
            return super.doTestConnection(AmazonEC2Cloud.getEc2EndpointUrl(region), accessId, secretKey, privateKey);
        }

        public FormValidation doGenerateKey(StaplerResponse rsp, @QueryParameter String region, @QueryParameter String accessId, @QueryParameter String secretKey) throws IOException, ServletException {
            return super.doGenerateKey(rsp, AmazonEC2Cloud.getEc2EndpointUrl(region), accessId, secretKey);
        }
    }
}

