/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceStateName;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2PrivateKey;
import hudson.plugins.ec2.EC2Slave;
import hudson.plugins.ec2.Messages;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EC2Cloud
extends Cloud {
    public static final String DEFAULT_EC2_HOST = "us-east-1";
    public static final String EC2_URL_HOST = "ec2.amazonaws.com";
    private final String accessId;
    private final Secret secretKey;
    private final EC2PrivateKey privateKey;
    public final int instanceCap;
    private final List<SlaveTemplate> templates;
    private transient KeyPair usableKeyPair;
    private transient AmazonEC2 connection;
    private static AWSCredentials awsCredentials;
    private static final Logger LOGGER;

    protected EC2Cloud(String id, String accessId, String secretKey, String privateKey, String instanceCapStr, List<SlaveTemplate> templates) {
        super(id);
        this.accessId = accessId.trim();
        this.secretKey = Secret.fromString((String)secretKey.trim());
        this.privateKey = new EC2PrivateKey(privateKey);
        this.instanceCap = instanceCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        if (templates == null) {
            templates = Collections.emptyList();
        }
        this.templates = templates;
        this.readResolve();
    }

    public abstract URL getEc2EndpointUrl() throws IOException;

    public abstract URL getS3EndpointUrl() throws IOException;

    protected Object readResolve() {
        for (SlaveTemplate t : this.templates) {
            t.parent = this;
        }
        return this;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getSecretKey() {
        return this.secretKey.getEncryptedValue();
    }

    public EC2PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public List<SlaveTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public SlaveTemplate getTemplate(String ami) {
        for (SlaveTemplate t : this.templates) {
            if (!t.ami.equals(ami)) continue;
            return t;
        }
        return null;
    }

    public SlaveTemplate getTemplate(Label label) {
        for (SlaveTemplate t : this.templates) {
            if (label != null && !label.matches((Collection)t.getLabelSet())) continue;
            return t;
        }
        return null;
    }

    public synchronized KeyPair getKeyPair() throws AmazonClientException, IOException {
        if (this.usableKeyPair == null) {
            this.usableKeyPair = this.privateKey.find(this.connect());
        }
        return this.usableKeyPair;
    }

    public int countCurrentEC2Slaves() throws AmazonClientException {
        int n = 0;
        for (Reservation r : this.connect().describeInstances().getReservations()) {
            for (Instance i : r.getInstances()) {
                InstanceStateName stateName = InstanceStateName.fromValue((String)i.getState().getName());
                if (stateName != InstanceStateName.Pending && stateName != InstanceStateName.Running) continue;
                ++n;
            }
        }
        return n;
    }

    public void doAttach(StaplerRequest req, StaplerResponse rsp, @QueryParameter String id) throws ServletException, IOException, AmazonClientException {
        this.checkPermission(PROVISION);
        SlaveTemplate t = this.getTemplates().get(0);
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        EC2Slave node = t.attach(id, (TaskListener)listener);
        Hudson.getInstance().addNode((Node)node);
        rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
    }

    public void doProvision(StaplerRequest req, StaplerResponse rsp, @QueryParameter String ami) throws ServletException, IOException {
        this.checkPermission(PROVISION);
        if (ami == null) {
            this.sendError("The 'ami' query parameter is missing", req, rsp);
            return;
        }
        SlaveTemplate t = this.getTemplate(ami);
        if (t == null) {
            this.sendError("No such AMI: " + ami, req, rsp);
            return;
        }
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        try {
            EC2Slave node = t.provision((TaskListener)listener);
            Hudson.getInstance().addNode((Node)node);
            rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
        }
        catch (AmazonClientException e) {
            e.printStackTrace(listener.error(e.getMessage()));
            this.sendError(sw.toString(), req, rsp);
        }
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        try {
            final SlaveTemplate t = this.getTemplate(label);
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            while (excessWorkload > 0) {
                if (this.countCurrentEC2Slaves() >= this.instanceCap) {
                    LOGGER.log(Level.INFO, "Instance cap reached, not provisioning.");
                    break;
                }
                r.add(new NodeProvisioner.PlannedNode(t.getDisplayName(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                    @Override
                    public Node call() throws Exception {
                        EC2Slave s = t.provision((TaskListener)new StreamTaskListener(System.out));
                        Hudson.getInstance().addNode((Node)s);
                        s.toComputer().connect(false).get();
                        return s;
                    }
                }), t.getNumExecutors()));
                --excessWorkload;
            }
            return r;
        }
        catch (AmazonClientException e) {
            LOGGER.log(Level.WARNING, "Failed to count the # of live instances on EC2", e);
            return Collections.emptyList();
        }
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    public static EC2Cloud get() {
        return (EC2Cloud)Hudson.getInstance().clouds.get(EC2Cloud.class);
    }

    public synchronized AmazonEC2 connect() throws AmazonClientException {
        try {
            if (this.connection == null) {
                this.connection = EC2Cloud.connect(this.accessId, this.secretKey, this.getEc2EndpointUrl());
            }
            return this.connection;
        }
        catch (IOException e) {
            throw new AmazonClientException("Failed to retrieve the endpoint", (Throwable)e);
        }
    }

    public static AmazonEC2 connect(String accessId, String secretKey, URL endpoint) {
        return EC2Cloud.connect(accessId, Secret.fromString((String)secretKey), endpoint);
    }

    public static AmazonEC2 connect(String accessId, Secret secretKey, URL endpoint) {
        awsCredentials = new BasicAWSCredentials(accessId, Secret.toString((Secret)secretKey));
        AmazonEC2Client client = new AmazonEC2Client(awsCredentials);
        client.setEndpoint(endpoint.toString());
        return client;
    }

    public static String convertHostName(String ec2HostName) {
        if (ec2HostName == null || ec2HostName.length() == 0) {
            ec2HostName = DEFAULT_EC2_HOST;
        }
        if (!ec2HostName.contains(".")) {
            ec2HostName = ec2HostName + "." + EC2_URL_HOST;
        }
        return ec2HostName;
    }

    public static Integer convertPort(String ec2Port) {
        if (ec2Port == null || ec2Port.length() == 0) {
            return -1;
        }
        return Integer.parseInt(ec2Port);
    }

    public URL buildPresignedURL(String path) throws IOException, AmazonClientException {
        long expires = System.currentTimeMillis() + 3600000L;
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(path, Secret.toString((Secret)this.secretKey));
        request.setExpiration(new Date(expires));
        AmazonS3Client s3 = new AmazonS3Client(awsCredentials);
        return s3.generatePresignedUrl(request);
    }

    public static URL checkEndPoint(String url) throws FormValidation {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw FormValidation.error((String)"Endpoint URL is not a valid URL");
        }
    }

    private static boolean isSSL(URL endpoint) {
        return endpoint.getProtocol().equals("https");
    }

    private static int portFromURL(URL endpoint) {
        int ec2Port = endpoint.getPort();
        if (ec2Port == -1) {
            ec2Port = endpoint.getDefaultPort();
        }
        return ec2Port;
    }

    static {
        LOGGER = Logger.getLogger(EC2Cloud.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DescriptorImpl
    extends Descriptor<Cloud> {
        public InstanceType[] getInstanceTypes() {
            return InstanceType.values();
        }

        public FormValidation doCheckAccessId(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateBase64((String)value, (boolean)false, (boolean)false, (String)Messages.EC2Cloud_InvalidAccessId());
        }

        public FormValidation doCheckSecretKey(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validateBase64((String)value, (boolean)false, (boolean)false, (String)Messages.EC2Cloud_InvalidSecretKey());
        }

        public FormValidation doCheckPrivateKey(@QueryParameter String value) throws IOException, ServletException {
            String line;
            boolean hasStart = false;
            boolean hasEnd = false;
            BufferedReader br = new BufferedReader(new StringReader(value));
            while ((line = br.readLine()) != null) {
                if (line.equals("-----BEGIN RSA PRIVATE KEY-----")) {
                    hasStart = true;
                }
                if (!line.equals("-----END RSA PRIVATE KEY-----")) continue;
                hasEnd = true;
            }
            if (!hasStart) {
                return FormValidation.error((String)"This doesn't look like a private key at all");
            }
            if (!hasEnd) {
                return FormValidation.error((String)"The private key is missing the trailing 'END RSA PRIVATE KEY' marker. Copy&paste error?");
            }
            return FormValidation.ok();
        }

        protected FormValidation doTestConnection(URL ec2endpoint, String accessId, String secretKey, String privateKey) throws IOException, ServletException {
            try {
                EC2PrivateKey pk;
                AmazonEC2 ec2 = EC2Cloud.connect(accessId, secretKey, ec2endpoint);
                ec2.describeInstances();
                if (accessId == null) {
                    return FormValidation.error((String)"Access ID is not specified");
                }
                if (secretKey == null) {
                    return FormValidation.error((String)"Secret key is not specified");
                }
                if (privateKey == null) {
                    return FormValidation.error((String)"Private key is not specified. Click 'Generate Key' to generate one.");
                }
                if (privateKey.trim().length() > 0 && (pk = new EC2PrivateKey(privateKey)).find(ec2) == null) {
                    return FormValidation.error((String)("The EC2 key pair private key isn't registered to this EC2 region (fingerprint is " + pk.getFingerprint() + ")"));
                }
                return FormValidation.ok((String)Messages.EC2Cloud_Success());
            }
            catch (AmazonClientException e) {
                LOGGER.log(Level.WARNING, "Failed to check EC2 credential", e);
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doGenerateKey(StaplerResponse rsp, URL ec2EndpointUrl, String accessId, String secretKey) throws IOException, ServletException {
            try {
                AmazonEC2 ec2 = EC2Cloud.connect(accessId, secretKey, ec2EndpointUrl);
                List existingKeys = ec2.describeKeyPairs().getKeyPairs();
                int n = 0;
                while (true) {
                    boolean found = false;
                    for (KeyPairInfo k : existingKeys) {
                        if (!k.getKeyName().equals("hudson-" + n)) continue;
                        found = true;
                    }
                    if (!found) break;
                    ++n;
                }
                CreateKeyPairRequest request = new CreateKeyPairRequest("hudson-" + n);
                KeyPair key = ec2.createKeyPair(request).getKeyPair();
                rsp.addHeader("script", "findPreviousFormItem(button,'privateKey').value='" + key.getKeyMaterial().replace("\n", "\\n") + "'");
                return FormValidation.ok((String)Messages.EC2Cloud_Success());
            }
            catch (AmazonClientException e) {
                LOGGER.log(Level.WARNING, "Failed to check EC2 credential", e);
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

