/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.GetConsoleOutputRequest;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import hudson.Util;
import hudson.model.Slave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Slave;
import hudson.plugins.ec2.InstanceState;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Collections;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;

public class EC2Computer
extends SlaveComputer {
    private volatile Instance ec2InstanceDescription;

    public EC2Computer(EC2Slave slave) {
        super((Slave)slave);
    }

    public EC2Slave getNode() {
        return (EC2Slave)super.getNode();
    }

    public String getInstanceId() {
        return this.getName();
    }

    public String getConsoleOutput() throws AmazonClientException {
        AmazonEC2 ec2 = EC2Cloud.get().connect();
        GetConsoleOutputRequest request = new GetConsoleOutputRequest(this.getInstanceId());
        return ec2.getConsoleOutput(request).getOutput();
    }

    public Instance describeInstance() throws AmazonClientException {
        if (this.ec2InstanceDescription == null) {
            this.ec2InstanceDescription = this._describeInstance();
        }
        return this.ec2InstanceDescription;
    }

    public Instance updateInstanceDescription() throws AmazonClientException {
        this.ec2InstanceDescription = this._describeInstance();
        return this.ec2InstanceDescription;
    }

    public InstanceState getState() throws AmazonClientException {
        this.ec2InstanceDescription = this._describeInstance();
        return InstanceState.find(this.ec2InstanceDescription.getState().getName());
    }

    public long getUptime() throws AmazonClientException {
        return System.currentTimeMillis() - this.describeInstance().getLaunchTime().getTime();
    }

    public String getUptimeString() throws AmazonClientException {
        return Util.getTimeSpanString((long)this.getUptime());
    }

    private Instance _describeInstance() throws AmazonClientException {
        DescribeInstancesRequest request = new DescribeInstancesRequest();
        request.setInstanceIds(Collections.singletonList(this.getNode().getInstanceId()));
        return (Instance)((Reservation)EC2Cloud.get().connect().describeInstances(request).getReservations().get(0)).getInstances().get(0);
    }

    public HttpResponse doDoDelete() throws IOException {
        this.checkPermission(DELETE);
        this.getNode().terminate();
        return new HttpRedirect("..");
    }

    public String getRemoteAdmin() {
        return this.getNode().getRemoteAdmin();
    }

    public int getSshPort() {
        return this.getNode().getSshPort();
    }

    public String getRootCommandPrefix() {
        return this.getNode().getRootCommandPrefix();
    }
}

