/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DeleteTagsRequest;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.Slave;
import hudson.plugins.ec2.AmazonEC2Cloud;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2RetentionStrategy;
import hudson.plugins.ec2.EC2Tag;
import hudson.plugins.ec2.ssh.EC2UnixLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.util.DescribableList;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.BindInterceptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EC2Slave
extends Slave {
    public final String initScript;
    public final String remoteAdmin;
    public final String rootCommandPrefix;
    public final String jvmopts;
    public final boolean stopOnTerminate;
    public final String idleTerminationMinutes;
    public String publicDNS;
    public String privateDNS;
    public List<EC2Tag> tags;
    public final boolean usePrivateDnsName;
    private long last_live_fetch = 0L;
    private static final long POLL_PERIOD = 20000L;
    private final int sshPort;
    public static final String TEST_ZONE = "testZone";
    private static final Logger LOGGER = Logger.getLogger(EC2Slave.class.getName());

    public EC2Slave(String instanceId, String description, String remoteFS, int sshPort, int numExecutors, String labelString, String initScript, String remoteAdmin, String rootCommandPrefix, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, String publicDNS, String privateDNS, List<EC2Tag> tags) throws Descriptor.FormException, IOException {
        this(instanceId, description, remoteFS, sshPort, numExecutors, Node.Mode.NORMAL, labelString, initScript, Collections.emptyList(), remoteAdmin, rootCommandPrefix, jvmopts, stopOnTerminate, idleTerminationMinutes, publicDNS, privateDNS, tags, false);
    }

    public EC2Slave(String instanceId, String description, String remoteFS, int sshPort, int numExecutors, String labelString, String initScript, String remoteAdmin, String rootCommandPrefix, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, String publicDNS, String privateDNS, List<EC2Tag> tags, boolean usePrivateDnsName) throws Descriptor.FormException, IOException {
        this(instanceId, description, remoteFS, sshPort, numExecutors, Node.Mode.NORMAL, labelString, initScript, Collections.emptyList(), remoteAdmin, rootCommandPrefix, jvmopts, stopOnTerminate, idleTerminationMinutes, publicDNS, privateDNS, tags, usePrivateDnsName);
    }

    @DataBoundConstructor
    public EC2Slave(String instanceId, String description, String remoteFS, int sshPort, int numExecutors, Node.Mode mode, String labelString, String initScript, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String rootCommandPrefix, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, String publicDNS, String privateDNS, List<EC2Tag> tags, boolean usePrivateDnsName) throws Descriptor.FormException, IOException {
        super(instanceId, description, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new EC2UnixLauncher(), (RetentionStrategy)new EC2RetentionStrategy(idleTerminationMinutes), nodeProperties);
        this.initScript = initScript;
        this.remoteAdmin = remoteAdmin;
        this.rootCommandPrefix = rootCommandPrefix;
        this.jvmopts = jvmopts;
        this.sshPort = sshPort;
        this.stopOnTerminate = stopOnTerminate;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.publicDNS = publicDNS;
        this.privateDNS = privateDNS;
        this.tags = tags;
        this.usePrivateDnsName = usePrivateDnsName;
    }

    public EC2Slave(String instanceId) throws Descriptor.FormException, IOException {
        this(instanceId, "debug", "/tmp/hudson", 22, 1, Node.Mode.NORMAL, "debug", "", Collections.emptyList(), null, null, null, false, null, "Fake public", "Fake private", null, false);
    }

    static int toNumExecutors(InstanceType it) {
        switch (it) {
            case T1Micro: {
                return 1;
            }
            case M1Small: {
                return 1;
            }
            case M1Medium: {
                return 2;
            }
            case M1Large: {
                return 4;
            }
            case C1Medium: {
                return 5;
            }
            case M2Xlarge: {
                return 6;
            }
            case M1Xlarge: {
                return 8;
            }
            case M22xlarge: {
                return 13;
            }
            case C1Xlarge: {
                return 20;
            }
            case M24xlarge: {
                return 26;
            }
            case Cc14xlarge: {
                return 33;
            }
            case Cg14xlarge: {
                return 33;
            }
        }
        throw new AssertionError();
    }

    public String getInstanceId() {
        return this.getNodeName();
    }

    public Computer createComputer() {
        return new EC2Computer(this);
    }

    public void terminate() {
        try {
            AmazonEC2 ec2 = EC2Cloud.get().connect();
            if (this.stopOnTerminate) {
                StopInstancesRequest request = new StopInstancesRequest(Collections.singletonList(this.getInstanceId()));
                ec2.stopInstances(request);
                LOGGER.info("Terminated EC2 instance (stopped): " + this.getInstanceId());
            } else {
                TerminateInstancesRequest request = new TerminateInstancesRequest(Collections.singletonList(this.getInstanceId()));
                ec2.terminateInstances(request);
                LOGGER.info("Terminated EC2 instance (terminated): " + this.getInstanceId());
            }
            Hudson.getInstance().removeNode((Node)this);
        }
        catch (AmazonClientException e) {
            LOGGER.log(Level.WARNING, "Failed to terminate EC2 instance: " + this.getInstanceId(), e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to terminate EC2 instance: " + this.getInstanceId(), e);
        }
    }

    String getRemoteAdmin() {
        if (this.remoteAdmin == null || this.remoteAdmin.length() == 0) {
            return "root";
        }
        return this.remoteAdmin;
    }

    String getRootCommandPrefix() {
        if (this.rootCommandPrefix == null || this.rootCommandPrefix.length() == 0) {
            return "";
        }
        return this.rootCommandPrefix + " ";
    }

    String getJvmopts() {
        return Util.fixNull((String)this.jvmopts);
    }

    public int getSshPort() {
        return this.sshPort != 0 ? this.sshPort : 22;
    }

    public boolean getStopOnTerminate() {
        return this.stopOnTerminate;
    }

    private void fetchLiveInstanceData(boolean force) throws AmazonClientException {
        long now = System.currentTimeMillis();
        if (this.last_live_fetch > 0L && now - this.last_live_fetch < 20000L && !force) {
            return;
        }
        this.last_live_fetch = now;
        DescribeInstancesRequest request = new DescribeInstancesRequest();
        request.setInstanceIds(Collections.singletonList(this.getNodeName()));
        Instance i = (Instance)((Reservation)EC2Cloud.get().connect().describeInstances(request).getReservations().get(0)).getInstances().get(0);
        this.publicDNS = i.getPublicDnsName();
        this.privateDNS = i.getPrivateIpAddress();
        this.tags = new LinkedList<EC2Tag>();
        for (Tag t : i.getTags()) {
            this.tags.add(new EC2Tag(t.getKey(), t.getValue()));
        }
    }

    private void clearLiveInstancedata() throws AmazonClientException {
        DescribeInstancesRequest request = new DescribeInstancesRequest();
        request.setInstanceIds(Collections.singletonList(this.getNodeName()));
        Instance inst = (Instance)((Reservation)EC2Cloud.get().connect().describeInstances(request).getReservations().get(0)).getInstances().get(0);
        if (!this.tags.isEmpty()) {
            HashSet<Tag> inst_tags = new HashSet<Tag>();
            for (EC2Tag t : this.tags) {
                inst_tags.add(new Tag(t.getName(), t.getValue()));
            }
            DeleteTagsRequest tag_request = new DeleteTagsRequest();
            tag_request.withResources(new String[]{inst.getInstanceId()}).setTags(inst_tags);
            EC2Cloud.get().connect().deleteTags(tag_request);
        }
    }

    private void pushLiveInstancedata() throws AmazonClientException {
        DescribeInstancesRequest request = new DescribeInstancesRequest();
        request.setInstanceIds(Collections.singletonList(this.getNodeName()));
        Instance inst = (Instance)((Reservation)EC2Cloud.get().connect().describeInstances(request).getReservations().get(0)).getInstances().get(0);
        if (!this.tags.isEmpty()) {
            HashSet<Tag> inst_tags = new HashSet<Tag>();
            for (EC2Tag t : this.tags) {
                inst_tags.add(new Tag(t.getName(), t.getValue()));
            }
            CreateTagsRequest tag_request = new CreateTagsRequest();
            tag_request.withResources(new String[]{inst.getInstanceId()}).setTags(inst_tags);
            EC2Cloud.get().connect().createTags(tag_request);
        }
    }

    public String getPublicDNS() {
        this.fetchLiveInstanceData(this.publicDNS == null);
        return this.publicDNS;
    }

    public String getPrivateDNS() {
        this.fetchLiveInstanceData(this.privateDNS == null);
        return this.privateDNS;
    }

    public List<EC2Tag> getTags() {
        this.fetchLiveInstanceData(false);
        return Collections.unmodifiableList(this.tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node reconfigure(final StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        if (form == null) {
            return null;
        }
        final JSONObject jsonForProperties = form.optJSONObject("nodeProperties");
        BindInterceptor old = req.setBindListener(new BindInterceptor(){

            public Object onConvert(Type targetType, Class targetTypeErasure, Object jsonSource) {
                if (jsonForProperties != jsonSource) {
                    return DEFAULT;
                }
                try {
                    DescribableList tmp = new DescribableList(Saveable.NOOP, (Collection)EC2Slave.this.getNodeProperties().toList());
                    tmp.rebuild(req, jsonForProperties, (List)NodeProperty.all());
                    return tmp.toList();
                }
                catch (Descriptor.FormException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        Node result = null;
        try {
            result = (Node)this.getDescriptor().newInstance(req, form);
        }
        finally {
            req.setBindListener(old);
        }
        this.fetchLiveInstanceData(true);
        this.clearLiveInstancedata();
        ((EC2Slave)result).pushLiveInstancedata();
        return result;
    }

    public boolean getUsePrivateDnsName() {
        return this.usePrivateDnsName;
    }

    public static ListBoxModel fillZoneItems(String accessId, String secretKey, String region) throws IOException, ServletException {
        ListBoxModel model = new ListBoxModel();
        if (AmazonEC2Cloud.testMode) {
            model.add(TEST_ZONE);
            return model;
        }
        if (!(StringUtils.isEmpty((String)accessId) || StringUtils.isEmpty((String)secretKey) || StringUtils.isEmpty((String)region))) {
            AmazonEC2 client = AmazonEC2Cloud.connect(accessId, secretKey, AmazonEC2Cloud.getEc2EndpointUrl(region));
            DescribeAvailabilityZonesResult zones = client.describeAvailabilityZones();
            List zoneList = zones.getAvailabilityZones();
            model.add("<not specified>", "");
            for (AvailabilityZone z : zoneList) {
                model.add(z.getZoneName(), z.getZoneName());
            }
        }
        return model;
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Amazon EC2";
        }

        public boolean isInstantiable() {
            return false;
        }

        public ListBoxModel doFillZoneItems(@QueryParameter String accessId, @QueryParameter String secretKey, @QueryParameter String region) throws IOException, ServletException {
            return EC2Slave.fillZoneItems(accessId, secretKey, region);
        }
    }
}

