/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.util.FormValidation;
import hudson.util.IOException2;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Eucalyptus
extends EC2Cloud {
    private transient Metadata metadata;
    public final URL url;

    @DataBoundConstructor
    public Eucalyptus(URL url, String accessId, String secretKey, String privateKey, String instanceCapStr, List<SlaveTemplate> templates) throws IOException {
        super("eucalyptus", accessId, secretKey, privateKey, instanceCapStr, templates);
        this.url = url;
    }

    private Metadata getMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = new Metadata(this.url);
        }
        return this.metadata;
    }

    @Override
    public URL getEc2EndpointUrl() throws IOException {
        return this.getMetadata().ec2endpoint;
    }

    @Override
    public URL getS3EndpointUrl() throws IOException {
        return this.getMetadata().s3endpoint;
    }

    static class Metadata {
        final URL ec2endpoint;
        final URL s3endpoint;

        Metadata(URL eucalyptus) throws IOException {
            if (!eucalyptus.getProtocol().equals("https")) {
                throw new IOException("Expecting an HTTPS URL but got " + eucalyptus);
            }
            URL metadataUrl = new URL(eucalyptus, "/register");
            try {
                HttpsURLConnection con = (HttpsURLConnection)metadataUrl.openConnection();
                this.makeIgnoreCertificate(con);
                Document metadata = new SAXReader().read(con.getInputStream());
                this.ec2endpoint = this.readURLFromMetadata(metadata, "ec2");
                this.s3endpoint = this.readURLFromMetadata(metadata, "s3");
            }
            catch (DocumentException e) {
                throw new IOException2("Failed to parse Eucalyptus metadata at " + metadataUrl, (Throwable)e);
            }
            catch (IOException e) {
                throw new IOException2("Failed to parse Eucalyptus metadata at " + metadataUrl, (Throwable)e);
            }
            catch (GeneralSecurityException e) {
                throw new IOException2("Failed to parse Eucalyptus metadata at " + metadataUrl, (Throwable)e);
            }
        }

        private void makeIgnoreCertificate(HttpsURLConnection con) throws NoSuchAlgorithmException, KeyManagementException {
            SSLContext sc = SSLContext.getInstance("SSL");
            TrustManager[] tma = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            sc.init(null, tma, null);
            con.setSSLSocketFactory(sc.getSocketFactory());
            con.setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
        }

        private URL readURLFromMetadata(Document metadata, String serviceName) throws MalformedURLException {
            Element e = (Element)metadata.selectSingleNode("//Service[Name/text()='" + serviceName + "']/EndpointUrl");
            if (e == null) {
                throw new IllegalStateException("Service metadata didn't contain " + serviceName);
            }
            return new URL(e.getTextTrim());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends EC2Cloud.DescriptorImpl {
        public String getDisplayName() {
            return "Eucalyptus";
        }

        public FormValidation doTestConnection(@QueryParameter URL url, @QueryParameter String accessId, @QueryParameter String secretKey, @QueryParameter String privateKey) throws IOException, ServletException {
            return super.doTestConnection(new Metadata((URL)url).ec2endpoint, accessId, secretKey, privateKey);
        }

        public FormValidation doGenerateKey(StaplerResponse rsp, @QueryParameter URL url, @QueryParameter String accessId, @QueryParameter String secretKey) throws IOException, ServletException {
            return super.doGenerateKey(rsp, new Metadata((URL)url).ec2endpoint, accessId, secretKey);
        }
    }
}

