/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2PrivateKey;
import hudson.plugins.ec2.EC2Slave;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.Secret;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.ServiceUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2Cloud
extends Cloud {
    private final String accessId;
    private final Secret secretKey;
    private final EC2PrivateKey privateKey;
    public final int instanceCap;
    private final List<SlaveTemplate> templates;
    private transient KeyPairInfo usableKeyPair;
    private static final Logger LOGGER = Logger.getLogger(EC2Cloud.class.getName());

    @DataBoundConstructor
    public EC2Cloud(String accessId, String secretKey, String privateKey, String instanceCapStr, List<SlaveTemplate> templates) {
        super("ec2");
        this.accessId = accessId.trim();
        this.secretKey = Secret.fromString((String)secretKey.trim());
        this.privateKey = new EC2PrivateKey(privateKey);
        this.instanceCap = instanceCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        if (templates == null) {
            templates = Collections.emptyList();
        }
        this.templates = templates;
        this.readResolve();
    }

    protected Object readResolve() {
        for (SlaveTemplate t : this.templates) {
            t.parent = this;
        }
        return this;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getSecretKey() {
        return this.secretKey.getEncryptedValue();
    }

    public EC2PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public List<SlaveTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public SlaveTemplate getTemplate(String ami) {
        for (SlaveTemplate t : this.templates) {
            if (!t.ami.equals(ami)) continue;
            return t;
        }
        return null;
    }

    public SlaveTemplate getTemplate(Label label) {
        for (SlaveTemplate t : this.templates) {
            if (!t.containsLabel(label)) continue;
            return t;
        }
        return null;
    }

    public synchronized KeyPairInfo getKeyPair() throws EC2Exception, IOException {
        if (this.usableKeyPair == null) {
            this.usableKeyPair = this.privateKey.find(this.connect());
        }
        return this.usableKeyPair;
    }

    public int countCurrentEC2Slaves() throws EC2Exception {
        int n = 0;
        for (ReservationDescription r : this.connect().describeInstances(Collections.emptyList())) {
            for (ReservationDescription.Instance i : r.getInstances()) {
                if (i.isTerminated()) continue;
                ++n;
            }
        }
        return n;
    }

    public void doAttach(StaplerRequest req, StaplerResponse rsp, @QueryParameter String id) throws ServletException, IOException, EC2Exception {
        this.checkPermission(PROVISION);
        SlaveTemplate t = (SlaveTemplate)this.getTemplates().get(0);
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        EC2Slave node = t.attach(id, (TaskListener)listener);
        Hudson.getInstance().addNode((Node)node);
        rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
    }

    public void doProvision(StaplerRequest req, StaplerResponse rsp, @QueryParameter String ami) throws ServletException, IOException {
        this.checkPermission(PROVISION);
        if (ami == null) {
            this.sendError("The 'ami' query parameter is missing", req, rsp);
            return;
        }
        SlaveTemplate t = this.getTemplate(ami);
        if (t == null) {
            this.sendError("No such AMI: " + ami, req, rsp);
            return;
        }
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        try {
            EC2Slave node = t.provision((TaskListener)listener);
            Hudson.getInstance().addNode((Node)node);
            rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
        }
        catch (EC2Exception e) {
            e.printStackTrace(listener.error(e.getMessage()));
            this.sendError(sw.toString(), req, rsp);
        }
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        try {
            SlaveTemplate t = this.getTemplate(label);
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            while (excessWorkload > 0 && this.countCurrentEC2Slaves() < this.instanceCap) {
                r.add(new NodeProvisioner.PlannedNode(t.getDisplayName(), Computer.threadPoolForRemoting.submit(new /* Unavailable Anonymous Inner Class!! */), t.getNumExecutors()));
                --excessWorkload;
            }
            return r;
        }
        catch (EC2Exception e) {
            LOGGER.log(Level.WARNING, "Failed to count the # of live instances on EC2", e);
            return Collections.emptyList();
        }
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    public static EC2Cloud get() {
        return (EC2Cloud)Hudson.getInstance().clouds.get(EC2Cloud.class);
    }

    public Jec2 connect() {
        return new Jec2(this.accessId, this.secretKey.toString());
    }

    public S3Service connectS3() throws S3ServiceException {
        return new RestS3Service(new AWSCredentials(this.accessId, this.secretKey.toString()));
    }

    public URL buildPresignedURL(String path) throws IOException, S3ServiceException {
        long expires = System.currentTimeMillis() / 1000L + 3600L;
        String token = "GET\n\n\n" + expires + "\n" + path;
        String url = "http://s3.amazonaws.com" + path + "?AWSAccessKeyId=" + this.accessId + "&Expires=" + expires + "&Signature=" + URLEncoder.encode(ServiceUtils.signWithHmacSha1((String)this.secretKey.toString(), (String)token), "UTF-8");
        return new URL(url);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

