/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Slave;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveTemplate
implements Describable<SlaveTemplate> {
    public final String ami;
    public final String description;
    public final String remoteFS;
    public final InstanceType type;
    public final String labels;
    public final String initScript;
    protected transient EC2Cloud parent;
    private transient Set<Label> labelSet;

    @DataBoundConstructor
    public SlaveTemplate(String ami, String remoteFS, InstanceType type, String labels, String description, String initScript) {
        this.ami = ami;
        this.remoteFS = remoteFS;
        this.type = type;
        this.labels = Util.fixNull((String)labels);
        this.description = description;
        this.initScript = initScript;
        this.readResolve();
    }

    public EC2Cloud getParent() {
        return this.parent;
    }

    public String getDisplayName() {
        return this.description + " (" + this.ami + ")";
    }

    public int getNumExecutors() {
        return EC2Slave.toNumExecutors((InstanceType)this.type);
    }

    public boolean containsLabel(Label l) {
        return l == null || this.labelSet.contains(l);
    }

    public EC2Slave provision(TaskListener listener) throws EC2Exception, IOException {
        PrintStream logger = listener.getLogger();
        Jec2 ec2 = this.getParent().connect();
        try {
            logger.println("Launching " + this.ami);
            KeyPairInfo keyPair = this.parent.getPrivateKey().find(ec2);
            if (keyPair == null) {
                throw new EC2Exception("No matching keypair found on EC2. Is the EC2 private key a valid one?");
            }
            ReservationDescription.Instance inst = (ReservationDescription.Instance)ec2.runInstances(this.ami, 1, 1, Collections.emptyList(), null, keyPair.getKeyName(), this.type).getInstances().get(0);
            return new EC2Slave(inst.getInstanceId(), this.description, this.remoteFS, this.type, this.labels, this.initScript);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
    }

    public EC2Slave attach(String instanceId, TaskListener listener) throws EC2Exception, IOException {
        PrintStream logger = listener.getLogger();
        Jec2 ec2 = this.getParent().connect();
        try {
            logger.println("Attaching to " + instanceId);
            ReservationDescription.Instance inst = (ReservationDescription.Instance)((ReservationDescription)ec2.describeInstances(Collections.singletonList(instanceId)).get(0)).getInstances().get(0);
            return new EC2Slave(inst.getInstanceId(), this.description, this.remoteFS, this.type, this.labels, this.initScript);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
    }

    protected Object readResolve() {
        this.labelSet = this.parse(this.labels);
        return this;
    }

    public Descriptor<SlaveTemplate> getDescriptor() {
        return Hudson.getInstance().getDescriptor(this.getClass());
    }

    private Set<Label> parse(String labels) {
        HashSet<Label> r = new HashSet<Label>();
        if ((labels = Util.fixNull((String)labels)).length() > 0) {
            for (String l : labels.split(" +")) {
                r.add(Hudson.getInstance().getLabel(l));
            }
        }
        return r;
    }
}

