/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.trilead.ssh2.crypto.Base64;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2PrivateKey;
import hudson.plugins.ec2.EC2Slave;
import hudson.plugins.ec2.Messages;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.StreamTaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.ServiceUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2Cloud
extends Cloud {
    private final String accessId;
    private final Secret secretKey;
    private final EC2PrivateKey privateKey;
    public final int instanceCap;
    private final List<SlaveTemplate> templates;
    private transient KeyPairInfo usableKeyPair;
    private static final Logger LOGGER = Logger.getLogger(EC2Cloud.class.getName());

    @DataBoundConstructor
    public EC2Cloud(String accessId, String secretKey, String privateKey, String instanceCapStr, List<SlaveTemplate> templates) {
        super("ec2");
        this.accessId = accessId.trim();
        this.secretKey = Secret.fromString((String)secretKey.trim());
        this.privateKey = new EC2PrivateKey(privateKey);
        this.instanceCap = instanceCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        if (templates == null) {
            templates = Collections.emptyList();
        }
        this.templates = templates;
        this.readResolve();
    }

    protected Object readResolve() {
        for (SlaveTemplate t : this.templates) {
            t.parent = this;
        }
        return this;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getSecretKey() {
        return this.secretKey.getEncryptedValue();
    }

    public EC2PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public List<SlaveTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public SlaveTemplate getTemplate(String ami) {
        for (SlaveTemplate t : this.templates) {
            if (!t.ami.equals(ami)) continue;
            return t;
        }
        return null;
    }

    public SlaveTemplate getTemplate(Label label) {
        for (SlaveTemplate t : this.templates) {
            if (!t.containsLabel(label)) continue;
            return t;
        }
        return null;
    }

    public synchronized KeyPairInfo getKeyPair() throws EC2Exception, IOException {
        if (this.usableKeyPair == null) {
            this.usableKeyPair = this.privateKey.find(this.connect());
        }
        return this.usableKeyPair;
    }

    public int countCurrentEC2Slaves() throws EC2Exception {
        int n = 0;
        for (ReservationDescription r : this.connect().describeInstances(Collections.emptyList())) {
            for (ReservationDescription.Instance i : r.getInstances()) {
                if (i.isTerminated()) continue;
                ++n;
            }
        }
        return n;
    }

    public void doAttach(StaplerRequest req, StaplerResponse rsp, @QueryParameter String id) throws ServletException, IOException, EC2Exception {
        this.checkPermission(PROVISION);
        SlaveTemplate t = this.getTemplates().get(0);
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        EC2Slave node = t.attach(id, (TaskListener)listener);
        Hudson.getInstance().addNode((Node)node);
        rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
    }

    public void doProvision(StaplerRequest req, StaplerResponse rsp, @QueryParameter String ami) throws ServletException, IOException {
        this.checkPermission(PROVISION);
        if (ami == null) {
            this.sendError("The 'ami' query parameter is missing", req, rsp);
            return;
        }
        SlaveTemplate t = this.getTemplate(ami);
        if (t == null) {
            this.sendError("No such AMI: " + ami, req, rsp);
            return;
        }
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        try {
            EC2Slave node = t.provision((TaskListener)listener);
            Hudson.getInstance().addNode((Node)node);
            rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
        }
        catch (EC2Exception e) {
            e.printStackTrace(listener.error(e.getMessage()));
            this.sendError(sw.toString(), req, rsp);
        }
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        try {
            final SlaveTemplate t = this.getTemplate(label);
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            while (excessWorkload > 0 && this.countCurrentEC2Slaves() < this.instanceCap) {
                r.add(new NodeProvisioner.PlannedNode(t.getDisplayName(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                    @Override
                    public Node call() throws Exception {
                        EC2Slave s = t.provision((TaskListener)new StreamTaskListener(System.out));
                        Hudson.getInstance().addNode((Node)s);
                        s.toComputer().connect(false).get();
                        return s;
                    }
                }), t.getNumExecutors()));
                --excessWorkload;
            }
            return r;
        }
        catch (EC2Exception e) {
            LOGGER.log(Level.WARNING, "Failed to count the # of live instances on EC2", e);
            return Collections.emptyList();
        }
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    public static EC2Cloud get() {
        return (EC2Cloud)Hudson.getInstance().clouds.get(EC2Cloud.class);
    }

    public Jec2 connect() {
        return new Jec2(this.accessId, this.secretKey.toString());
    }

    public S3Service connectS3() throws S3ServiceException {
        return new RestS3Service(new AWSCredentials(this.accessId, this.secretKey.toString()));
    }

    public URL buildPresignedURL(String path) throws IOException, S3ServiceException {
        long expires = System.currentTimeMillis() / 1000L + 3600L;
        String token = "GET\n\n\n" + expires + "\n" + path;
        String url = "http://s3.amazonaws.com" + path + "?AWSAccessKeyId=" + this.accessId + "&Expires=" + expires + "&Signature=" + URLEncoder.encode(ServiceUtils.signWithHmacSha1((String)this.secretKey.toString(), (String)token), "UTF-8");
        return new URL(url);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Amazon EC2";
        }

        public InstanceType[] getInstanceTypes() {
            return InstanceType.values();
        }

        private FormValidation validateBase64(String value, boolean allowWhitespace, boolean allowEmpty, String errorMessage) {
            try {
                String v = value;
                if (!(allowWhitespace || v.indexOf(32) < 0 && v.indexOf(10) < 0)) {
                    return FormValidation.error((String)errorMessage);
                }
                v = v.trim();
                if (!allowEmpty && v.length() == 0) {
                    return FormValidation.error((String)errorMessage);
                }
                Base64.decode((char[])v.toCharArray());
                return FormValidation.ok();
            }
            catch (IOException e) {
                return FormValidation.error((String)errorMessage);
            }
        }

        public FormValidation doCheckAccessId(@QueryParameter String value) throws IOException, ServletException {
            return this.validateBase64(value, false, false, Messages.EC2Cloud_InvalidAccessId());
        }

        public FormValidation doCheckSecretKey(@QueryParameter String value) throws IOException, ServletException {
            return this.validateBase64(value, false, false, Messages.EC2Cloud_InvalidSecretKey());
        }

        public FormValidation doCheckPrivateKey(@QueryParameter String value) throws IOException, ServletException {
            String line;
            boolean hasStart = false;
            boolean hasEnd = false;
            BufferedReader br = new BufferedReader(new StringReader(value));
            while ((line = br.readLine()) != null) {
                if (line.equals("-----BEGIN RSA PRIVATE KEY-----")) {
                    hasStart = true;
                }
                if (!line.equals("-----END RSA PRIVATE KEY-----")) continue;
                hasEnd = true;
            }
            if (!hasStart) {
                return FormValidation.error((String)"This doesn't look like a private key at all");
            }
            if (!hasEnd) {
                return FormValidation.error((String)"The private key is missing the trailing 'END RSA PRIVATE KEY' marker. Copy&paste error?");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestConnection(@QueryParameter String accessId, @QueryParameter String secretKey, @QueryParameter String privateKey) throws IOException, ServletException {
            try {
                EC2PrivateKey pk;
                Jec2 jec2 = new Jec2(accessId, Secret.fromString((String)secretKey).toString());
                jec2.describeInstances(Collections.emptyList());
                if (accessId == null) {
                    return FormValidation.error((String)"Access ID is not specified");
                }
                if (secretKey == null) {
                    return FormValidation.error((String)"Secret key is not specified");
                }
                if (privateKey == null) {
                    return FormValidation.error((String)"Private key is not specified. Click 'Generate Key' to generate one.");
                }
                if (privateKey.trim().length() > 0 && (pk = new EC2PrivateKey(privateKey)).find(jec2) == null) {
                    return FormValidation.error((String)("The private key entered below isn't registred to EC2 (fingerprint is " + pk.getFingerprint() + ")"));
                }
                return FormValidation.ok((String)Messages.EC2Cloud_Success());
            }
            catch (EC2Exception e) {
                LOGGER.log(Level.WARNING, "Failed to check EC2 credential", e);
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doGenerateKey(StaplerResponse rsp, @QueryParameter String accessId, @QueryParameter String secretKey) throws IOException, ServletException {
            try {
                Jec2 jec2 = new Jec2(accessId, Secret.fromString((String)secretKey).toString());
                List existingKeys = jec2.describeKeyPairs(Collections.emptyList());
                int n = 0;
                while (true) {
                    boolean found = false;
                    for (KeyPairInfo k : existingKeys) {
                        if (!k.getKeyName().equals("hudson-" + n)) continue;
                        found = true;
                    }
                    if (!found) break;
                    ++n;
                }
                KeyPairInfo key = jec2.createKeyPair("hudson-" + n);
                rsp.addHeader("script", "findPreviousFormItem(button,'privateKey').value='" + key.getKeyMaterial().replace("\n", "\\n") + "'");
                return FormValidation.ok((String)Messages.EC2Cloud_Success());
            }
            catch (EC2Exception e) {
                LOGGER.log(Level.WARNING, "Failed to check EC2 credential", e);
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

