/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.ReservationDescription;
import hudson.Util;
import hudson.model.Slave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Slave;
import hudson.plugins.ec2.InstanceState;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Collections;
import org.kohsuke.stapler.StaplerResponse;

public class EC2Computer
extends SlaveComputer {
    private volatile ReservationDescription.Instance ec2InstanceDescription;

    public EC2Computer(EC2Slave slave) {
        super((Slave)slave);
    }

    public EC2Slave getNode() {
        return (EC2Slave)super.getNode();
    }

    public String getInstanceId() {
        return this.getName();
    }

    public String getConsoleOutput() throws EC2Exception {
        Jec2 ec2 = EC2Cloud.get().connect();
        return ec2.getConsoleOutput(this.getInstanceId()).getOutput();
    }

    public ReservationDescription.Instance describeInstance() throws EC2Exception {
        if (this.ec2InstanceDescription == null) {
            this.ec2InstanceDescription = this._describeInstance();
        }
        return this.ec2InstanceDescription;
    }

    public InstanceState getState() throws EC2Exception {
        this.ec2InstanceDescription = this._describeInstance();
        return InstanceState.find(this.ec2InstanceDescription.getState());
    }

    public long getUptime() throws EC2Exception {
        return System.currentTimeMillis() - this.describeInstance().getLaunchTime().getTimeInMillis();
    }

    public String getUptimeString() throws EC2Exception {
        return Util.getTimeSpanString((long)this.getUptime());
    }

    private ReservationDescription.Instance _describeInstance() throws EC2Exception {
        return (ReservationDescription.Instance)((ReservationDescription)EC2Cloud.get().connect().describeInstances(Collections.singletonList(this.getNode().getInstanceId())).get(0)).getInstances().get(0);
    }

    public void doDoDelete(StaplerResponse rsp) throws IOException {
        this.checkPermission(DELETE);
        this.getNode().terminate();
        rsp.sendRedirect("..");
    }
}

