// CHECKSTYLE:OFF

package hudson.plugins.ec2;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Success
     * 
     */
    public static String EC2Cloud_Success() {
        return holder.format("EC2Cloud.Success");
    }

    /**
     * Success
     * 
     */
    public static Localizable _EC2Cloud_Success() {
        return new Localizable(holder, "EC2Cloud.Success");
    }

    /**
     * Invalid AWS access key ID
     * 
     */
    public static String EC2Cloud_InvalidAccessId() {
        return holder.format("EC2Cloud.InvalidAccessId");
    }

    /**
     * Invalid AWS access key ID
     * 
     */
    public static Localizable _EC2Cloud_InvalidAccessId() {
        return new Localizable(holder, "EC2Cloud.InvalidAccessId");
    }

    /**
     * US West
     * 
     */
    public static String AwsRegion_UsWest() {
        return holder.format("AwsRegion.UsWest");
    }

    /**
     * US West
     * 
     */
    public static Localizable _AwsRegion_UsWest() {
        return new Localizable(holder, "AwsRegion.UsWest");
    }

    /**
     * US East
     * 
     */
    public static String AwsRegion_UsEast() {
        return holder.format("AwsRegion.UsEast");
    }

    /**
     * US East
     * 
     */
    public static Localizable _AwsRegion_UsEast() {
        return new Localizable(holder, "AwsRegion.UsEast");
    }

    /**
     * EU West
     * 
     */
    public static String AwsRegion_EuWest() {
        return holder.format("AwsRegion.EuWest");
    }

    /**
     * EU West
     * 
     */
    public static Localizable _AwsRegion_EuWest() {
        return new Localizable(holder, "AwsRegion.EuWest");
    }

    /**
     * Invalid AWS secret access key
     * 
     */
    public static String EC2Cloud_InvalidSecretKey() {
        return holder.format("EC2Cloud.InvalidSecretKey");
    }

    /**
     * Invalid AWS secret access key
     * 
     */
    public static Localizable _EC2Cloud_InvalidSecretKey() {
        return new Localizable(holder, "EC2Cloud.InvalidSecretKey");
    }

}
