/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.ec2.AmazonEC2Cloud;
import hudson.plugins.ec2.EC2PrivateKey;
import hudson.plugins.ec2.EC2Slave;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.ServiceUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class EC2Cloud
extends Cloud {
    private final String accessId;
    private final Secret secretKey;
    private final EC2PrivateKey privateKey;
    public final int instanceCap;
    private final List<SlaveTemplate> templates;
    private transient KeyPairInfo usableKeyPair;
    private static final Logger LOGGER = Logger.getLogger(EC2Cloud.class.getName());

    protected EC2Cloud(String id, String accessId, String secretKey, String privateKey, String instanceCapStr, List<SlaveTemplate> templates) {
        super(id);
        this.accessId = accessId.trim();
        this.secretKey = Secret.fromString((String)secretKey.trim());
        this.privateKey = new EC2PrivateKey(privateKey);
        this.instanceCap = instanceCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        if (templates == null) {
            templates = Collections.emptyList();
        }
        this.templates = templates;
        this.readResolve();
    }

    public abstract URL getEc2EndpointUrl() throws IOException;

    public abstract URL getS3EndpointUrl() throws IOException;

    protected Object readResolve() {
        for (SlaveTemplate t : this.templates) {
            t.parent = this;
        }
        return this;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getSecretKey() {
        return this.secretKey.getEncryptedValue();
    }

    public EC2PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public List<SlaveTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public SlaveTemplate getTemplate(String ami) {
        for (SlaveTemplate t : this.templates) {
            if (!t.ami.equals(ami)) continue;
            return t;
        }
        return null;
    }

    public SlaveTemplate getTemplate(Label label) {
        for (SlaveTemplate t : this.templates) {
            if (!t.containsLabel(label)) continue;
            return t;
        }
        return null;
    }

    public synchronized KeyPairInfo getKeyPair() throws EC2Exception, IOException {
        if (this.usableKeyPair == null) {
            this.usableKeyPair = this.privateKey.find(this.connect());
        }
        return this.usableKeyPair;
    }

    public int countCurrentEC2Slaves() throws EC2Exception {
        int n = 0;
        for (ReservationDescription r : this.connect().describeInstances(Collections.emptyList())) {
            for (ReservationDescription.Instance i : r.getInstances()) {
                if (i.isTerminated()) continue;
                ++n;
            }
        }
        return n;
    }

    public void doAttach(StaplerRequest req, StaplerResponse rsp, @QueryParameter String id) throws ServletException, IOException, EC2Exception {
        this.checkPermission(PROVISION);
        SlaveTemplate t = (SlaveTemplate)this.getTemplates().get(0);
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        EC2Slave node = t.attach(id, (TaskListener)listener);
        Hudson.getInstance().addNode((Node)node);
        rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
    }

    public void doProvision(StaplerRequest req, StaplerResponse rsp, @QueryParameter String ami) throws ServletException, IOException {
        this.checkPermission(PROVISION);
        if (ami == null) {
            this.sendError("The 'ami' query parameter is missing", req, rsp);
            return;
        }
        SlaveTemplate t = this.getTemplate(ami);
        if (t == null) {
            this.sendError("No such AMI: " + ami, req, rsp);
            return;
        }
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        try {
            EC2Slave node = t.provision((TaskListener)listener);
            Hudson.getInstance().addNode((Node)node);
            rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
        }
        catch (EC2Exception e) {
            e.printStackTrace(listener.error(e.getMessage()));
            this.sendError(sw.toString(), req, rsp);
        }
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        try {
            SlaveTemplate t = this.getTemplate(label);
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            while (excessWorkload > 0 && this.countCurrentEC2Slaves() < this.instanceCap) {
                r.add(new NodeProvisioner.PlannedNode(t.getDisplayName(), Computer.threadPoolForRemoting.submit(new /* Unavailable Anonymous Inner Class!! */), t.getNumExecutors()));
                --excessWorkload;
            }
            return r;
        }
        catch (EC2Exception e) {
            LOGGER.log(Level.WARNING, "Failed to count the # of live instances on EC2", e);
            return Collections.emptyList();
        }
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    public static EC2Cloud get() {
        return (EC2Cloud)Hudson.getInstance().clouds.get(EC2Cloud.class);
    }

    public Jec2 connect() throws EC2Exception {
        try {
            return EC2Cloud.connect((String)this.accessId, (Secret)this.secretKey, (URL)this.getEc2EndpointUrl());
        }
        catch (IOException e) {
            throw new EC2Exception("Failed to retrieve the endpoint", (Exception)e);
        }
    }

    public static Jec2 connect(String accessId, String secretKey, URL endpoint) {
        return EC2Cloud.connect((String)accessId, (Secret)Secret.fromString((String)secretKey), (URL)endpoint);
    }

    public static Jec2 connect(String accessId, Secret secretKey, URL endpoint) {
        int ec2Port = EC2Cloud.portFromURL((URL)endpoint);
        boolean SSL = EC2Cloud.isSSL((URL)endpoint);
        Jec2 result = new Jec2(accessId, secretKey.toString(), SSL, endpoint.getHost(), ec2Port);
        String path = endpoint.getPath();
        if (path.length() != 0) {
            result.setResourcePrefix(path);
        }
        return result;
    }

    public static String convertHostName(String ec2HostName) {
        if (ec2HostName == null || ec2HostName.length() == 0) {
            ec2HostName = "us-east-1";
        }
        if (!ec2HostName.contains(".")) {
            ec2HostName = ec2HostName + ".ec2.amazonaws.com";
        }
        return ec2HostName;
    }

    public static String convertS3HostName(String s3HostName) {
        if (s3HostName == null || s3HostName.length() == 0) {
            s3HostName = "s3";
        }
        if (!s3HostName.contains(".")) {
            s3HostName = s3HostName + ".amazonaws.com";
        }
        return s3HostName;
    }

    public static Integer convertPort(String ec2Port) {
        if (ec2Port == null || ec2Port.length() == 0) {
            return -1;
        }
        return Integer.parseInt(ec2Port);
    }

    public S3Service connectS3() throws S3ServiceException, IOException {
        URL s3 = this.getS3EndpointUrl();
        return new RestS3Service(new AWSCredentials(this.accessId, this.secretKey.toString()), null, null, this.buildJets3tProperties(s3));
    }

    protected Jets3tProperties buildJets3tProperties(URL s3) {
        int s3Port;
        Jets3tProperties props = Jets3tProperties.getInstance((String)Constants.JETS3T_PROPERTIES_FILENAME);
        String s3Host = s3.getHost();
        if (!s3Host.equals("s3.amazonaws.com")) {
            props.setProperty("s3service.s3-endpoint", s3Host);
        }
        if ((s3Port = EC2Cloud.portFromURL((URL)s3)) != -1) {
            props.setProperty("s3service.s3-endpoint-http-port", String.valueOf(s3Port));
        }
        if (s3.getPath().length() > 1) {
            props.setProperty("s3service.s3-endpoint-virtual-path", s3.getPath());
        }
        props.setProperty("s3service.https-only", String.valueOf(EC2Cloud.isSSL((URL)s3)));
        return props;
    }

    public URL buildPresignedURL(String path) throws IOException, S3ServiceException {
        long expires = System.currentTimeMillis() / 1000L + 3600L;
        String token = "GET\n\n\n" + expires + "\n" + path;
        String url = "http://s3.amazonaws.com" + path + "?AWSAccessKeyId=" + this.accessId + "&Expires=" + expires + "&Signature=" + URLEncoder.encode(ServiceUtils.signWithHmacSha1((String)this.secretKey.toString(), (String)token), "UTF-8");
        return new URL(url);
    }

    public static URL checkEndPoint(String url) throws FormValidation {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw FormValidation.error((String)"Endpoint URL is not a valid URL");
        }
    }

    private static boolean isSSL(URL endpoint) {
        return endpoint.getProtocol().equals("https");
    }

    private static int portFromURL(URL endpoint) {
        int ec2Port = endpoint.getPort();
        if (ec2Port == -1) {
            ec2Port = endpoint.getDefaultPort();
        }
        return ec2Port;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static {
        Hudson.XSTREAM.alias(EC2Cloud.class.getName(), AmazonEC2Cloud.class);
    }
}

