/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2ComputerLauncher;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.jets3t.service.S3ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2UnixLauncher
extends EC2ComputerLauncher {
    private final int FAILED = -1;
    private final int SAMEUSER = 0;
    private final int RECONNECT = -2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launch(EC2Computer computer, PrintStream logger, ReservationDescription.Instance inst) throws IOException, EC2Exception, InterruptedException, S3ServiceException {
        logger.println("Connecting to " + inst.getDnsName());
        Connection cleanupConn = null;
        boolean successful = false;
        try {
            Session sess;
            Connection bootstrapConn = this.connectToSsh(inst);
            int bootstrapResult = this.bootstrap(bootstrapConn, computer, logger);
            if (bootstrapResult == -1) {
                return;
            }
            if (bootstrapResult == 0) {
                cleanupConn = bootstrapConn;
            } else {
                KeyPairInfo key;
                cleanupConn = this.connectToSsh(inst);
                if (!cleanupConn.authenticateWithPublicKey("root", (key = EC2Cloud.get().getKeyPair()).getKeyMaterial().toCharArray(), "")) {
                    logger.println("Authentication failed");
                    return;
                }
            }
            Connection conn = cleanupConn;
            SCPClient scp = conn.createSCPClient();
            String initScript = computer.getNode().initScript;
            if (initScript != null && initScript.trim().length() > 0 && conn.exec("test -e /.hudson-run-init", (OutputStream)logger) != 0) {
                logger.println("Executing init script");
                scp.put(initScript.getBytes("UTF-8"), "init.sh", "/tmp", "0700");
                sess = conn.openSession();
                sess.requestDumbPTY();
                sess.execCommand(computer.getRootCommandPrefix() + "/tmp/init.sh");
                sess.getStdin().close();
                sess.getStderr().close();
                IOUtils.copy((InputStream)sess.getStdout(), (OutputStream)logger);
                int exitStatus = this.waitCompletion(sess);
                if (exitStatus != 0) {
                    logger.println("init script failed: exit code=" + exitStatus);
                    return;
                }
                scp.put(new byte[0], ".hudson-run-init", "/", "0600");
            }
            logger.println("Verifying that java exists");
            if (conn.exec("java -fullversion", (OutputStream)logger) != 0) {
                logger.println("Installing Java");
                String jdk = "java1.6.0_12";
                String path = "/hudson-ci/jdk/linux-i586/" + jdk + ".tgz";
                URL url = EC2Cloud.get().buildPresignedURL(path);
                if (conn.exec("wget -nv -O /usr/" + jdk + ".tgz '" + url + "'", (OutputStream)logger) != 0) {
                    logger.println("Failed to download Java");
                    return;
                }
                if (conn.exec("tar xz -C /usr -f /usr/" + jdk + ".tgz", (OutputStream)logger) != 0) {
                    logger.println("Failed to install Java");
                    return;
                }
                if (conn.exec("ln -s /usr/" + jdk + "/bin/java /bin/java", (OutputStream)logger) != 0) {
                    logger.println("Failed to symlink Java");
                    return;
                }
            }
            logger.println("Copying slave.jar");
            scp.put(Hudson.getInstance().getJnlpJars("slave.jar").readFully(), "slave.jar", "/tmp");
            logger.println("Launching slave agent");
            sess = conn.openSession();
            sess.execCommand("java -jar /tmp/slave.jar");
            computer.setChannel(sess.getStdout(), sess.getStdin(), (OutputStream)logger, (Channel.Listener)new /* Unavailable Anonymous Inner Class!! */);
            successful = true;
        }
        finally {
            if (cleanupConn != null && !successful) {
                cleanupConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int bootstrap(Connection bootstrapConn, EC2Computer computer, PrintStream logger) throws IOException, InterruptedException, EC2Exception {
        boolean closeBootstrap = true;
        try {
            int tries = 20;
            boolean isAuthenticated = false;
            KeyPairInfo key = EC2Cloud.get().getKeyPair();
            while (tries-- > 0 && !(isAuthenticated = bootstrapConn.authenticateWithPublicKey(computer.getRemoteAdmin(), key.getKeyMaterial().toCharArray(), ""))) {
                logger.println("Authentication failed. Trying again...");
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            if (!isAuthenticated) {
                logger.println("Authentication failed");
                int n = -1;
                return n;
            }
            if (!computer.getRemoteAdmin().equals("root")) {
                Session sess = bootstrapConn.openSession();
                sess.requestDumbPTY();
                sess.execCommand(computer.getRootCommandPrefix() + "cp ~/.ssh/authorized_keys /root/.ssh/");
                sess.getStdin().close();
                sess.getStderr().close();
                IOUtils.copy((InputStream)sess.getStdout(), (OutputStream)logger);
                int exitStatus = this.waitCompletion(sess);
                if (exitStatus != 0) {
                    logger.println("init script failed: exit code=" + exitStatus);
                    int n = -1;
                    return n;
                }
                int n = -2;
                return n;
            }
            closeBootstrap = false;
            int n = 0;
            return n;
        }
        finally {
            if (closeBootstrap) {
                bootstrapConn.close();
            }
        }
    }

    private Connection connectToSsh(ReservationDescription.Instance inst) throws InterruptedException {
        while (true) {
            try {
                Connection conn = new Connection(inst.getDnsName(), 22);
                conn.connect((ServerHostKeyVerifier)new /* Unavailable Anonymous Inner Class!! */);
                return conn;
            }
            catch (IOException e) {
                Thread.sleep(5000L);
                continue;
            }
            break;
        }
    }

    private int waitCompletion(Session session) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            Integer r = session.getExitStatus();
            if (r != null) {
                return r;
            }
            Thread.sleep(100L);
        }
        return -1;
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

