/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.plugins.ec2.AwsRegion;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonEC2Cloud
extends EC2Cloud {
    private AwsRegion region;

    @DataBoundConstructor
    public AmazonEC2Cloud(AwsRegion region, String accessId, String secretKey, String privateKey, String instanceCapStr, List<SlaveTemplate> templates) {
        super("ec2-" + region.name(), accessId, secretKey, privateKey, instanceCapStr, templates);
        this.region = region;
    }

    public AwsRegion getRegion() {
        if (this.region == null) {
            this.region = AwsRegion.US_EAST_1;
        }
        return this.region;
    }

    @Override
    public URL getEc2EndpointUrl() {
        return this.getRegion().ec2Endpoint;
    }

    @Override
    public URL getS3EndpointUrl() {
        return this.getRegion().s3Endpoint;
    }

    @Extension
    public static class DescriptorImpl
    extends EC2Cloud.DescriptorImpl {
        public String getDisplayName() {
            return "Amazon EC2";
        }

        public FormValidation doTestConnection(@QueryParameter AwsRegion region, @QueryParameter String accessId, @QueryParameter String secretKey, @QueryParameter String privateKey) throws IOException, ServletException {
            return super.doTestConnection(region.ec2Endpoint, accessId, secretKey, privateKey);
        }

        public FormValidation doGenerateKey(StaplerResponse rsp, @QueryParameter AwsRegion region, @QueryParameter String accessId, @QueryParameter String secretKey) throws IOException, ServletException {
            return super.doGenerateKey(rsp, region.ec2Endpoint, accessId, secretKey);
        }
    }
}

